/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepository;
import io.crnk.core.resource.links.DefaultPagedLinksInformation;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceListBase;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import io.crnk.data.jpa.JpaRepositoryFilter;
import io.crnk.data.jpa.mapping.IdentityMapper;
import io.crnk.data.jpa.mapping.JpaMapper;
import io.crnk.data.jpa.query.JpaQueryFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.jodah.typetools.TypeResolver;

public class JpaRepositoryConfig<T> {
    private Class<?> entityClass;
    private Class<T> resourceClass;
    private JpaMapper<?, T> mapper;
    private Class<? extends DefaultResourceList<T>> listClass;
    private Class<? extends MetaInformation> listMetaClass;
    private Class<? extends LinksInformation> listLinksClass;
    private Boolean totalAvailable;
    private List<JpaRepositoryFilter> filters = new ArrayList<JpaRepositoryFilter>();
    private Supplier<JpaQueryFactory> queryFactory;

    private JpaRepositoryConfig() {
    }

    public JpaQueryFactory getQueryFactory() {
        PreconditionUtil.verify((this.queryFactory != null ? 1 : 0) != 0, (String)"queryFactory not set, make sure the JpaModule is setup and discovered by Crnk", (Object[])new Object[0]);
        return this.queryFactory.get();
    }

    public boolean hasQueryFactory() {
        return this.queryFactory != null;
    }

    public void setQueryFactory(JpaQueryFactory queryFactory) {
        if (this.queryFactory != null) {
            throw new IllegalStateException("queryFactory already set");
        }
        this.queryFactory = () -> queryFactory;
    }

    public void setQueryFactory(Supplier<JpaQueryFactory> queryFactorySupplier) {
        if (this.queryFactory != null) {
            throw new IllegalStateException("queryFactory already set");
        }
        this.queryFactory = queryFactorySupplier;
    }

    public boolean hasTotalAvailable() {
        return this.totalAvailable != null;
    }

    public boolean isTotalAvailable() {
        this.totalAvailable = DefaultPagedMetaInformation.class.isAssignableFrom(this.listMetaClass) && (this.totalAvailable == null || this.totalAvailable != false);
        return this.totalAvailable;
    }

    public void setTotalAvailable(Boolean totalAvailable) {
        this.totalAvailable = totalAvailable;
    }

    public void addFilter(JpaRepositoryFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(JpaRepositoryFilter filter) {
        this.filters.remove(filter);
    }

    public List<JpaRepositoryFilter> getFilters() {
        return this.filters;
    }

    public static <E> JpaRepositoryConfig<E> create(Class<E> entityClass) {
        return JpaRepositoryConfig.builder(entityClass).build();
    }

    public static <E> Builder<E> builder(Class<E> entityClass) {
        Builder builder = new Builder();
        builder.entityClass = entityClass;
        builder.resourceClass = entityClass;
        return builder;
    }

    public static <E, D> Builder<D> builder(Class<E> entityClass, Class<D> dtoClass, JpaMapper<E, D> mapper) {
        Builder builder = new Builder();
        builder.entityClass = entityClass;
        builder.resourceClass = dtoClass;
        builder.mapper = mapper;
        return builder;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    public Class<? extends MetaInformation> getListMetaClass() {
        return this.listMetaClass;
    }

    public Class<? extends LinksInformation> getListLinksClass() {
        return this.listLinksClass;
    }

    public <E> JpaMapper<E, T> getMapper() {
        return this.mapper;
    }

    public <M extends MetaInformation, L extends LinksInformation> Class<? extends ResourceListBase<T, M, L>> getListClass() {
        return this.listClass;
    }

    public DefaultResourceList<T> newResultList() {
        DefaultResourceList list = (DefaultResourceList)ClassUtils.newInstance(this.listClass);
        list.setMeta(this.newMetaInformation());
        list.setLinks(this.newLinksInformation());
        return list;
    }

    private MetaInformation newMetaInformation() {
        if (this.listMetaClass != null) {
            return (MetaInformation)ClassUtils.newInstance(this.listMetaClass);
        }
        return null;
    }

    private LinksInformation newLinksInformation() {
        if (this.listLinksClass != null) {
            return (LinksInformation)ClassUtils.newInstance(this.listLinksClass);
        }
        return null;
    }

    public boolean isNextFetched(QuerySpec querySpec) {
        return querySpec.getLimit() != null && !this.isTotalAvailable() && this.getListMetaClass() != null && HasMoreResourcesMetaInformation.class.isAssignableFrom(this.getListMetaClass());
    }

    public boolean isTotalFetched(QuerySpec querySpec) {
        return (querySpec.getOffset() != 0L || querySpec.getLimit() != null) && this.isTotalAvailable() && this.getListMetaClass() != null && PagedMetaInformation.class.isAssignableFrom(this.getListMetaClass());
    }

    protected void setListMetaClass(Class<? extends MetaInformation> listMetaClass) {
        this.listMetaClass = listMetaClass;
    }

    public static class Builder<T> {
        private Class<?> entityClass;
        private Class<T> resourceClass;
        private JpaMapper<?, T> mapper = IdentityMapper.newInstance();
        private Class<? extends DefaultResourceList<T>> listClass = DefaultResourceList.class;
        private Class<? extends MetaInformation> listMetaClass = DefaultPagedMetaInformation.class;
        private Class<? extends LinksInformation> listLinksClass = DefaultPagedLinksInformation.class;

        public JpaRepositoryConfig<T> build() {
            JpaRepositoryConfig config = new JpaRepositoryConfig();
            config.entityClass = this.entityClass;
            config.resourceClass = this.resourceClass;
            config.mapper = this.mapper;
            config.listClass = this.listClass;
            config.listMetaClass = this.listMetaClass;
            config.listLinksClass = this.listLinksClass;
            return config;
        }

        public Builder<T> setInterfaceClass(Class<? extends ResourceRepository<T, ?>> interfaceClass) {
            try {
                Method findMethod = interfaceClass.getDeclaredMethod("findAll", QuerySpec.class);
                Class<?> returnType = findMethod.getReturnType();
                if (!ResourceListBase.class.isAssignableFrom(returnType)) {
                    throw new IllegalStateException("findAll return type must extend " + ResourceListBase.class.getName());
                }
                this.setListClass(returnType);
                Class[] typeArgs = TypeResolver.resolveRawArguments(ResourceListBase.class, returnType);
                this.setListMetaClass(typeArgs[1]);
                this.setListLinksClass(typeArgs[2]);
                return this;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("findAll method not overriden by " + interfaceClass.getName(), e);
            }
        }

        public Builder<T> setListClass(Class<? extends DefaultResourceList<T>> listClass) {
            this.listClass = listClass;
            return this;
        }

        public Builder<T> setListMetaClass(Class<? extends MetaInformation> listMetaClass) {
            this.listMetaClass = listMetaClass;
            return this;
        }

        public Builder<T> setListLinksClass(Class<? extends LinksInformation> listLinksClass) {
            this.listLinksClass = listLinksClass;
            return this;
        }
    }
}

