/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.module.Module;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJpaExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Module.ModuleContext context;

    public AbstractJpaExceptionMapper(Module.ModuleContext context) {
        this.context = context;
    }

    public ErrorResponse toErrorResponse(E exception) {
        Optional mapper;
        Throwable cause = ((Throwable)exception).getCause();
        if (cause != null && (mapper = this.context.getExceptionMapperRegistry().findMapperFor(cause.getClass())).isPresent()) {
            return ((ExceptionMapper)mapper.get()).toErrorResponse(cause);
        }
        this.LOGGER.error("failed to process request due to jpa exception", exception);
        int status = this.getStatus();
        ErrorData errorData = ErrorData.builder().setStatus(Integer.toString(status)).setTitle(((Throwable)exception).getMessage()).build();
        return ErrorResponse.builder().setSingleErrorData(errorData).setStatus(status).build();
    }

    protected int getStatus() {
        return 500;
    }

    public E fromErrorResponse(ErrorResponse errorResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean accepts(ErrorResponse errorResponse) {
        return false;
    }
}

