/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.data.jpa.JpaRepositoryConfig;
import io.crnk.data.jpa.internal.JpaRepositoryConfigSupplier;
import java.util.List;
import javax.persistence.EntityManager;

public abstract class JpaRepositoryBase<T>
implements JpaRepositoryConfigSupplier {
    protected JpaRepositoryConfig<T> repositoryConfig;

    protected JpaRepositoryBase(JpaRepositoryConfig<T> repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }

    public EntityManager getEntityManager() {
        EntityManager em = this.repositoryConfig.getQueryFactory().getEntityManager();
        PreconditionUtil.verify((em != null ? 1 : 0) != 0, (String)("entityManager not available, make sure to pass an EntityManager to XyQueryFactory.create(em) when using " + this.getClass().getSimpleName() + " in standalone without a JpaModule"), (Object[])new Object[0]);
        return em;
    }

    @Override
    public JpaRepositoryConfig<T> getRepositoryConfig() {
        return this.repositoryConfig;
    }

    protected <D> D getUnique(List<D> list, Object id) {
        if (list.isEmpty()) {
            throw new ResourceNotFoundException("resource not found: type=" + this.repositoryConfig.getResourceClass().getSimpleName() + " id=" + id);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new IllegalStateException("unique result expected: " + this.repositoryConfig.getResourceClass().getSimpleName() + " id=" + id);
    }
}

