/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal.query;

import io.crnk.data.jpa.query.AnyTypeObject;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.provider.MetaPartition;

public class AnyUtils {
    private static final Object TYPE_ATTRIBUTE = "type";

    private AnyUtils() {
    }

    public static void setValue(MetaPartition partition, AnyTypeObject dataObject, Object value) {
        MetaDataObject meta = (MetaDataObject)partition.getMeta(dataObject.getClass());
        if (value == null) {
            for (MetaAttribute attr : meta.getAttributes()) {
                attr.setValue((Object)dataObject, null);
            }
        } else {
            boolean found = false;
            for (MetaAttribute attr : meta.getAttributes()) {
                if (attr.getName().equals(TYPE_ATTRIBUTE)) continue;
                if (attr.getType().getImplementationClass().isAssignableFrom(value.getClass())) {
                    attr.setValue((Object)dataObject, value);
                    found = true;
                    continue;
                }
                attr.setValue((Object)dataObject, null);
            }
            if (!found) {
                throw new IllegalStateException("cannot assign " + value + " to " + dataObject);
            }
        }
    }

    public static MetaAttribute findAttribute(MetaDataObject meta, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null as value not supported");
        }
        for (MetaAttribute attr : meta.getAttributes()) {
            if (attr.getName().equals(TYPE_ATTRIBUTE) || attr.isDerived() || !attr.getType().getImplementationClass().isAssignableFrom(value.getClass())) continue;
            return attr;
        }
        throw new IllegalArgumentException("cannot find anyType attribute for value '" + value + '\'');
    }
}

