/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal.query;

import io.crnk.data.jpa.internal.query.AbstractJpaQueryImpl;
import io.crnk.data.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaMapAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.criteria.JoinType;

public class JoinRegistry<F, E> {
    private Map<MetaAttributePath, F> joinMap = new HashMap<MetaAttributePath, F>();
    private JpaQueryBackend<F, ?, ?, E> backend;
    private AbstractJpaQueryImpl<?, ?> query;

    public JoinRegistry(JpaQueryBackend<F, ?, ?, E> backend, AbstractJpaQueryImpl<?, ?> query) {
        this.backend = backend;
        this.query = query;
    }

    protected static MetaAttributePath extractAssociationPath(MetaAttributePath path) {
        for (int i = path.length() - 1; i >= 0; --i) {
            MetaAttribute element = path.getElement(i);
            if (!element.isAssociation()) continue;
            return path.subPath(0, i + 1);
        }
        return new MetaAttributePath(new MetaAttribute[0]);
    }

    public E getEntityAttribute(MetaAttributePath attrPath) {
        return this.getEntityAttribute(attrPath, this.query.getDefaultJoinType());
    }

    public E getEntityAttribute(MetaAttributePath attrPath, JoinType defaultJoinType) {
        MetaAttributePath associationPath = JoinRegistry.extractAssociationPath(attrPath);
        MetaAttributePath primitivePath = attrPath.subPath(associationPath.length());
        F from = this.getOrCreateJoin(associationPath, defaultJoinType);
        if (primitivePath.length() == 0) {
            return (E)from;
        }
        MetaAttributePath currentPath = associationPath;
        Object criteriaPath = null;
        for (MetaAttribute pathElement : primitivePath) {
            Class<?> currentType;
            boolean isSubType;
            Object currentCriteriaPath;
            currentPath = currentPath.concat(new MetaAttribute[]{pathElement});
            Object v0 = currentCriteriaPath = criteriaPath != null ? criteriaPath : from;
            if (pathElement instanceof MetaMapAttribute) {
                if (criteriaPath != null) {
                    throw new IllegalStateException("Cannot join to map");
                }
                criteriaPath = this.joinMap(currentCriteriaPath, pathElement);
                continue;
            }
            MetaDataObject parent = pathElement.getParent().asDataObject();
            Class pathType = parent.getImplementationClass();
            boolean bl = isSubType = !pathType.isAssignableFrom(currentType = this.backend.getJavaElementType(currentCriteriaPath));
            if (isSubType) {
                currentCriteriaPath = this.backend.joinSubType(currentCriteriaPath, pathType);
            }
            criteriaPath = this.backend.getAttribute(currentCriteriaPath, pathElement);
        }
        return criteriaPath;
    }

    private E joinMap(E currentCriteriaPath, MetaAttribute pathElement) {
        MetaMapAttribute mapPathElement = (MetaMapAttribute)pathElement;
        return this.backend.joinMapValue(currentCriteriaPath, pathElement, mapPathElement.getKey());
    }

    public F getOrCreateJoin(MetaAttributePath path, JoinType defaultJoinType) {
        if (path.length() == 0) {
            return this.backend.getRoot();
        }
        MetaAttributePath subPath = new MetaAttributePath(new MetaAttribute[0]);
        F from = this.backend.getRoot();
        for (int i = 0; i < path.length(); ++i) {
            MetaAttribute pathElement = path.getElement(i);
            from = this.getOrCreateJoin(subPath, pathElement, defaultJoinType);
            subPath = subPath.concat(new MetaAttribute[]{pathElement});
        }
        return from;
    }

    private F getOrCreateJoin(MetaAttributePath srcPath, MetaAttribute targetAttr, JoinType defaultJoinType) {
        MetaAttributePath path = srcPath.concat(new MetaAttribute[]{targetAttr});
        F parent = this.joinMap.get(srcPath);
        F join = this.joinMap.get(path);
        if (join == null) {
            JoinType joinType = this.query.getJoinType(path, defaultJoinType);
            if (targetAttr instanceof MetaMapAttribute) {
                MetaMapAttribute targetMapAttr = (MetaMapAttribute)targetAttr;
                join = this.backend.joinMapRelation(parent, (MetaAttribute)targetMapAttr, targetMapAttr.getKey());
            } else {
                join = this.backend.doJoin(targetAttr, joinType, parent);
            }
            this.joinMap.put(path, join);
        }
        return join;
    }

    public void putJoin(MetaAttributePath path, F root) {
        if (this.joinMap.containsKey(path)) {
            throw new IllegalArgumentException(path.toString() + " already exists");
        }
        this.joinMap.put(path, root);
    }
}

