/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.internal.query;

import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.data.jpa.internal.query.AbstractJpaQueryImpl;
import io.crnk.data.jpa.internal.query.ComputedAttributeRegistryImpl;
import io.crnk.data.jpa.internal.query.MetaComputedAttribute;
import io.crnk.data.jpa.internal.query.QueryFilterBuilder;
import io.crnk.data.jpa.internal.query.QuerySortBuilder;
import io.crnk.data.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributeFinder;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaPrimaryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryBuilder<T, F, O, P, E> {
    private static final String SORT_COLUMN_ALIAS_PREFIX = "__sort";
    private JpaQueryBackend<F, O, P, E> backend;
    private AbstractJpaQueryImpl<T, ?> query;
    private MetaAttributeFinder attributeFinder;

    public QueryBuilder(AbstractJpaQueryImpl<T, ?> query, JpaQueryBackend<F, O, P, E> backend) {
        this.query = query;
        this.backend = backend;
        final ComputedAttributeRegistryImpl virtualAttrs = query.getComputedAttrs();
        this.attributeFinder = new MetaAttributeFinder(){

            public MetaAttribute getAttribute(MetaDataObject meta, String name) {
                MetaComputedAttribute attr = virtualAttrs.get(meta, name);
                if (attr != null) {
                    return attr;
                }
                return meta.findAttribute(name, true);
            }
        };
    }

    protected int applyDistinct() {
        boolean distinct;
        int numAutoSelections = 0;
        if (this.query.autoDistinct) {
            boolean bl = distinct = this.query.autoDistinct && !this.query.autoGroupBy && this.backend.hasManyRootsFetchesOrJoins();
            if (distinct) {
                numAutoSelections = this.addOrderExpressionsToSelection();
            }
        } else {
            distinct = this.query.distinct;
        }
        if (distinct) {
            this.backend.distinct();
        }
        return numAutoSelections;
    }

    public Map<String, Integer> applySelectionSpec() {
        MetaDataObject meta = this.query.getMeta();
        HashMap<String, Integer> selectionBindings = new HashMap<String, Integer>();
        int index = 1;
        List<IncludeFieldSpec> includedFields = this.query.getIncludedFields();
        for (IncludeFieldSpec includedField : includedFields) {
            MetaAttributePath path = meta.resolvePath(includedField.getAttributePath(), this.attributeFinder);
            E attr = this.backend.getAttribute(path);
            this.backend.addSelection(attr, path.toString());
            selectionBindings.put(path.toString(), index++);
        }
        return selectionBindings;
    }

    private int addOrderExpressionsToSelection() {
        int numAutoSelections = 0;
        int prefixIndex = 0;
        ArrayList<O> newOrderList = new ArrayList<O>();
        for (O order : this.backend.getOrderList()) {
            E expression = this.backend.getExpression(order);
            if (this.backend.containsRelation(expression)) {
                this.backend.addSelection(expression, SORT_COLUMN_ALIAS_PREFIX + prefixIndex++);
                ++numAutoSelections;
            }
            newOrderList.add(order);
        }
        this.backend.setOrder(newOrderList);
        return numAutoSelections;
    }

    public void applySortSpec() {
        QuerySortBuilder<T, E, O> orderBuilder = new QuerySortBuilder<T, E, O>(this.query, this.backend, this.attributeFinder);
        orderBuilder.applySortSpec();
    }

    public void applyFilterSpec() {
        MetaAttribute parentAttr;
        QueryFilterBuilder<P, F> predicateBuilder = new QueryFilterBuilder<P, F>(this.backend, this.attributeFinder);
        MetaDataObject meta = this.query.getMeta();
        List<FilterSpec> filters = this.query.getFilterSpecs();
        List<P> predicates = predicateBuilder.filterSpecListToPredicateArray(meta, this.backend.getRoot(), filters);
        if (predicates != null && !predicates.isEmpty()) {
            this.backend.addPredicate(this.backend.and(predicates));
        }
        if ((parentAttr = this.query.getParentAttr()) != null) {
            MetaDataObject parentMeta = this.query.getParentMeta();
            MetaPrimaryKey primaryKey = parentMeta.getPrimaryKey();
            if (primaryKey == null) {
                throw new IllegalStateException("primary key not found for " + parentAttr.getId());
            }
            MetaAttribute primaryKeyAttr = primaryKey.getUniqueElement();
            this.backend.addParentPredicate(primaryKeyAttr);
        }
    }

    public E getExpression(PathSpec path) {
        MetaDataObject meta = this.query.getMeta();
        MetaAttributePath metaAttributePath = meta.resolvePath(path.getElements());
        return this.backend.getAttribute(metaAttributePath);
    }
}

