/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.meta.internal;

import io.crnk.data.jpa.meta.JpaMetaProvider;
import io.crnk.data.jpa.meta.MetaJpaDataObject;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.resource.MetaJsonObject;
import io.crnk.meta.provider.MetaFilter;
import io.crnk.meta.provider.MetaFilterBase;
import io.crnk.meta.provider.MetaProvider;
import io.crnk.meta.provider.MetaProviderBase;
import java.util.Arrays;
import java.util.Collection;

public class JpaMetaEnricher
extends MetaFilterBase {
    private JpaMetaProvider metaProvider;

    public MetaProvider getProvider() {
        return new MetaProviderBase(){

            public Collection<MetaFilter> getFilters() {
                return Arrays.asList(new MetaFilter[]{JpaMetaEnricher.this});
            }
        };
    }

    public void onInitialized(MetaElement element) {
        if (!(element instanceof MetaJsonObject)) {
            return;
        }
        MetaJsonObject jsonDataObject = (MetaJsonObject)element;
        Class implementationClass = jsonDataObject.getImplementationClass();
        if (implementationClass == Object.class || !this.metaProvider.hasMeta(implementationClass)) {
            return;
        }
        Object metaElement = this.metaProvider.getMeta(implementationClass);
        MetaJpaDataObject jpaDataObject = (MetaJpaDataObject)((Object)metaElement);
        if (jpaDataObject.getPrimaryKey() != null && jsonDataObject.getPrimaryKey() != null) {
            jsonDataObject.getPrimaryKey().setGenerated(jpaDataObject.getPrimaryKey().isGenerated());
        }
        for (MetaAttribute declaredAttribute : jsonDataObject.getDeclaredAttributes()) {
            String name = declaredAttribute.getName();
            if (!jpaDataObject.hasAttribute(name)) continue;
            MetaAttribute jpaAttribute = jpaDataObject.getAttribute(name);
            declaredAttribute.setLob(jpaAttribute.isLob());
            declaredAttribute.setVersion(jpaAttribute.isVersion());
            declaredAttribute.setNullable(jpaAttribute.isNullable());
            declaredAttribute.setCascaded(jpaAttribute.isCascaded());
        }
    }

    public void setMetaProvider(JpaMetaProvider metaProvider) {
        this.metaProvider = metaProvider;
    }
}

