/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.meta.internal;

import io.crnk.data.jpa.meta.internal.EmbeddableMetaFactory;
import io.crnk.data.jpa.meta.internal.EntityMetaProvider;
import io.crnk.data.jpa.meta.internal.MappedSuperclassMetaFactory;
import io.crnk.meta.internal.MetaIdProvider;
import io.crnk.meta.internal.typed.TypedMetaElementFactory;
import io.crnk.meta.internal.typed.TypedMetaPartitionBase;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaPartitionContext;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;

public class JpaMetaPartition
extends TypedMetaPartitionBase {
    private final MetaIdProvider idProvider;
    private final Set<Class> jpaTypes;

    public JpaMetaPartition(Set<Class> jpaTypes, MetaIdProvider idProvider) {
        this.idProvider = idProvider;
        this.jpaTypes = jpaTypes;
        this.addFactory((TypedMetaElementFactory)new EmbeddableMetaFactory());
        this.addFactory((TypedMetaElementFactory)new MappedSuperclassMetaFactory());
        this.addFactory((TypedMetaElementFactory)new EntityMetaProvider());
    }

    public void init(MetaPartitionContext context) {
        super.init(context);
        this.parent = context.getBasePartition();
    }

    protected Optional<MetaElement> addElement(Type type, MetaElement element) {
        if (element instanceof MetaType) {
            MetaType typeElement = element.asType();
            if (!element.hasId()) {
                element.setId(this.computeId(typeElement));
            }
        }
        return super.addElement(type, element);
    }

    private String computeId(MetaType element) {
        Class implementationClass = element.getImplementationClass();
        return this.idProvider.computeIdPrefixFromPackage(implementationClass, (MetaElement)element) + element.getName();
    }

    public void discoverElements() {
        for (Class jpaType : this.jpaTypes) {
            this.allocateMetaElement(jpaType);
        }
    }
}

