/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa.query.querydsl;

import io.crnk.data.jpa.internal.JpaQueryFactoryBase;
import io.crnk.data.jpa.internal.query.backend.querydsl.QuerydslQueryImpl;
import io.crnk.data.jpa.query.JpaQueryFactory;
import io.crnk.data.jpa.query.querydsl.QuerydslExpressionFactory;
import io.crnk.data.jpa.query.querydsl.QuerydslQuery;
import io.crnk.data.jpa.query.querydsl.QuerydslTranslationInterceptor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.EntityManager;

public class QuerydslQueryFactory
extends JpaQueryFactoryBase
implements JpaQueryFactory {
    private List<QuerydslTranslationInterceptor> interceptors = new CopyOnWriteArrayList<QuerydslTranslationInterceptor>();

    private QuerydslQueryFactory() {
    }

    public static QuerydslQueryFactory newInstance() {
        return new QuerydslQueryFactory();
    }

    public static QuerydslQueryFactory newInstance(EntityManager em) {
        QuerydslQueryFactory factory = new QuerydslQueryFactory();
        factory.initalize(QuerydslQueryFactory.createDefaultContext(em));
        return factory;
    }

    public void addInterceptor(QuerydslTranslationInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public <T> QuerydslQuery<T> query(Class<T> entityClass) {
        return new QuerydslQueryImpl<T>(this.context.getMetaPartition(), this.getEntityManager(), entityClass, this.computedAttrs, this.interceptors);
    }

    public <T> QuerydslQuery<T> query(Class<?> entityClass, String attrName, String parentKey, List<?> entityIds) {
        return new QuerydslQueryImpl(this.context.getMetaPartition(), this.getEntityManager(), entityClass, this.computedAttrs, this.interceptors, attrName, parentKey, entityIds);
    }

    public void registerComputedAttribute(Class<?> targetClass, String attributeName, Type attributeType, QuerydslExpressionFactory<?> expressionFactory) {
        this.computedAttrs.register(targetClass, attributeName, expressionFactory, attributeType);
    }
}

