/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import io.crnk.jpa.JpaModule;
import io.crnk.jpa.JpaRepositoryConfig;
import io.crnk.jpa.internal.JpaRepositoryBase;
import io.crnk.jpa.internal.JpaRepositoryUtils;
import io.crnk.jpa.internal.JpaRequestContext;
import io.crnk.jpa.mapping.JpaMapper;
import io.crnk.jpa.meta.MetaEntity;
import io.crnk.jpa.query.ComputedAttributeRegistry;
import io.crnk.jpa.query.JpaQuery;
import io.crnk.jpa.query.JpaQueryExecutor;
import io.crnk.jpa.query.JpaQueryFactory;
import io.crnk.jpa.query.Tuple;
import io.crnk.meta.model.MetaAttribute;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class JpaEntityRepository<T, I extends Serializable>
extends JpaRepositoryBase<T>
implements ResourceRepositoryV2<T, I> {
    private MetaEntity meta;
    private MetaAttribute primaryKeyAttr;

    public JpaEntityRepository(JpaModule module, JpaRepositoryConfig<T> config) {
        super(module, config);
        this.meta = (MetaEntity)((Object)module.getJpaMetaProvider().getMeta(config.getEntityClass()));
        this.primaryKeyAttr = JpaRepositoryUtils.getPrimaryKeyAttr(this.meta);
    }

    public final T findOne(I id, QuerySpec querySpec) {
        QuerySpec idQuerySpec = querySpec.duplicate();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(this.primaryKeyAttr.getName()), FilterOperator.EQ, id));
        ResourceList<T> results = this.findAll(idQuerySpec);
        return JpaEntityRepository.getUnique(results, id);
    }

    public final ResourceList<T> findAll(Iterable<I> ids, QuerySpec querySpec) {
        QuerySpec idQuerySpec = querySpec.duplicate();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(this.primaryKeyAttr.getName()), FilterOperator.EQ, ids));
        return this.findAll(idQuerySpec);
    }

    public ResourceList<T> findAll(QuerySpec querySpec) {
        Class<?> entityClass = this.repositoryConfig.getEntityClass();
        QuerySpec filteredQuerySpec = this.filterQuerySpec(querySpec);
        JpaQueryFactory queryFactory = this.module.getQueryFactory();
        JpaQuery<?> query = queryFactory.query(entityClass);
        query.setPrivateData(new JpaRequestContext(this, querySpec));
        ComputedAttributeRegistry computedAttributesRegistry = queryFactory.getComputedAttributes();
        Set<String> computedAttrs = computedAttributesRegistry.getForType(entityClass);
        JpaRepositoryUtils.prepareQuery(query, filteredQuerySpec, computedAttrs);
        query = this.filterQuery(filteredQuerySpec, query);
        JpaQueryExecutor<?> executor = query.buildExecutor();
        boolean fetchNext = this.isNextFetched(filteredQuerySpec);
        boolean fetchTotal = this.isTotalFetched(filteredQuerySpec);
        JpaRepositoryUtils.prepareExecutor(executor, filteredQuerySpec, this.fetchRelations(null));
        if (fetchNext) {
            executor.setLimit(executor.getLimit() + 1);
        }
        executor = this.filterExecutor(filteredQuerySpec, executor);
        List<Tuple> tuples = executor.getResultTuples();
        Boolean hasNext = null;
        if (fetchNext && (hasNext = Boolean.valueOf((long)tuples.size() == querySpec.getLimit() + 1L)).booleanValue()) {
            tuples = tuples.subList(0, querySpec.getLimit().intValue());
        }
        tuples = this.filterTuples(filteredQuerySpec, tuples);
        DefaultResourceList resources = this.repositoryConfig.newResultList();
        MetaInformation metaInfo = resources.getMeta();
        this.fillResourceList(tuples, resources);
        resources = this.filterResults(filteredQuerySpec, resources);
        if (fetchTotal) {
            long totalRowCount = executor.getTotalRowCount();
            ((PagedMetaInformation)metaInfo).setTotalResourceCount(Long.valueOf(totalRowCount));
        }
        if (fetchNext) {
            ((HasMoreResourcesMetaInformation)metaInfo).setHasMoreResources(hasNext);
        }
        return resources;
    }

    public <S extends T> S create(S resource) {
        return this.saveInternal(resource);
    }

    public <S extends T> S save(S resource) {
        return this.saveInternal(resource);
    }

    private <S extends T> S saveInternal(S resource) {
        JpaMapper mapper = this.repositoryConfig.getMapper();
        Object entity = mapper.unmap(resource);
        EntityManager em = this.module.getEntityManager();
        em.persist(entity);
        Serializable id = (Serializable)em.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity);
        QuerySpec querySpec = new QuerySpec(this.repositoryConfig.getResourceClass());
        PreconditionUtil.verify((id != null ? 1 : 0) != 0, (String)"id not available for entity %s", (Object[])new Object[]{resource});
        return (S)this.findOne(id, querySpec);
    }

    public void delete(I id) {
        EntityManager em = this.module.getEntityManager();
        Object object = em.find(this.repositoryConfig.getEntityClass(), id);
        if (object != null) {
            em.remove(object);
        }
    }

    public Class<T> getResourceClass() {
        return this.repositoryConfig.getResourceClass();
    }

    public Class<?> getEntityClass() {
        return this.repositoryConfig.getEntityClass();
    }
}

