/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.filter.AbstractDocumentFilter;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.filter.DocumentFilterContext;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.transaction.TransactionRunner;
import io.crnk.core.module.InitializingModule;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtension;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.decorate.RelationshipRepositoryDecorator;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import io.crnk.core.repository.decorate.ResourceRepositoryDecorator;
import io.crnk.core.resource.meta.DefaultHasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import io.crnk.jpa.JpaEntityRepository;
import io.crnk.jpa.JpaModuleConfig;
import io.crnk.jpa.JpaRelationshipRepository;
import io.crnk.jpa.JpaRepositoryConfig;
import io.crnk.jpa.JpaRepositoryFactory;
import io.crnk.jpa.JpaRepositoryFilter;
import io.crnk.jpa.internal.JpaRepositoryBase;
import io.crnk.jpa.internal.JpaRequestContext;
import io.crnk.jpa.internal.JpaResourceInformationProvider;
import io.crnk.jpa.internal.OptimisticLockExceptionMapper;
import io.crnk.jpa.internal.PersistenceExceptionMapper;
import io.crnk.jpa.internal.PersistenceRollbackExceptionMapper;
import io.crnk.jpa.internal.query.backend.querydsl.QuerydslQueryImpl;
import io.crnk.jpa.meta.JpaMetaProvider;
import io.crnk.jpa.meta.MetaEntity;
import io.crnk.jpa.meta.internal.JpaMetaEnricher;
import io.crnk.jpa.query.JpaQueryFactory;
import io.crnk.jpa.query.JpaQueryFactoryContext;
import io.crnk.jpa.query.querydsl.QuerydslQueryFactory;
import io.crnk.jpa.query.querydsl.QuerydslRepositoryFilter;
import io.crnk.jpa.query.querydsl.QuerydslTranslationContext;
import io.crnk.jpa.query.querydsl.QuerydslTranslationInterceptor;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.MetaModuleExtension;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaProvider;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaModule
implements InitializingModule {
    private static final String MODULE_NAME = "jpa";
    private Logger logger = LoggerFactory.getLogger(JpaModule.class);
    private EntityManagerFactory emFactory;
    private EntityManager em;
    private ResourceInformationProvider resourceInformationProvider;
    private TransactionRunner transactionRunner;
    private Module.ModuleContext context;
    private JpaModuleConfig config;
    private JpaMetaEnricher metaEnricher;
    private MetaLookup jpaMetaLookup;
    private JpaMetaProvider jpaMetaProvider;

    protected JpaModule() {
    }

    private JpaModule(JpaModuleConfig config, EntityManagerFactory emFactory, EntityManager em, TransactionRunner transactionRunner) {
        this();
        this.config = config;
        this.emFactory = emFactory;
        this.em = em;
        this.transactionRunner = transactionRunner;
    }

    public static JpaModule newClientModule() {
        return new JpaModule();
    }

    @Deprecated
    public static JpaModule newServerModule(EntityManager em, TransactionRunner transactionRunner) {
        return new JpaModule(new JpaModuleConfig(), null, em, transactionRunner);
    }

    @Deprecated
    public static JpaModule newServerModule(EntityManagerFactory emFactory, EntityManager em, TransactionRunner transactionRunner) {
        JpaModuleConfig config = new JpaModuleConfig();
        config.exposeAllEntities(emFactory);
        return new JpaModule(config, emFactory, em, transactionRunner);
    }

    public static JpaModule createServerModule(JpaModuleConfig config, EntityManager em, TransactionRunner transactionRunner) {
        return new JpaModule(config, null, em, transactionRunner);
    }

    @Deprecated
    public void addFilter(JpaRepositoryFilter filter) {
        this.config.addFilter(filter);
    }

    @Deprecated
    public void removeFilter(JpaRepositoryFilter filter) {
        this.config.removeFilter(filter);
    }

    @Deprecated
    public List<JpaRepositoryFilter> getFilters() {
        return this.config.getFilters();
    }

    @Deprecated
    public void setRepositoryFactory(JpaRepositoryFactory repositoryFactory) {
        this.checkNotInitialized();
        this.config.setRepositoryFactory(repositoryFactory);
    }

    @Deprecated
    public Set<Class<?>> getResourceClasses() {
        return this.config.getResourceClasses();
    }

    @Deprecated
    public <T> void addRepository(JpaRepositoryConfig<T> config) {
        this.checkNotInitialized();
        this.config.addRepository(config);
    }

    public <T> void removeRepository(Class<T> resourceClass) {
        this.checkNotInitialized();
        this.config.removeRepository(resourceClass);
    }

    public void removeRepositories() {
        this.checkNotInitialized();
        this.config.removeRepositories();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    private void checkNotInitialized() {
        PreconditionUtil.assertNull((String)"module is already initialized, no further changes can be performed", (Object)this.context);
    }

    public void setupModule(Module.ModuleContext context) {
        this.context = context;
        HashSet<Class> jpaTypes = new HashSet<Class>();
        if (this.config != null) {
            for (JpaRepositoryConfig config : this.config.getRepositories()) {
                jpaTypes.add(config.getEntityClass());
            }
        }
        this.jpaMetaProvider = new JpaMetaProvider(jpaTypes);
        this.jpaMetaLookup = new MetaLookup();
        this.jpaMetaLookup.addProvider((MetaProvider)this.jpaMetaProvider);
        this.jpaMetaLookup.setModuleContext(context);
        this.jpaMetaLookup.initialize();
        if (this.config != null) {
            this.initQueryFactory();
        }
        context.addResourceInformationBuilder(this.getResourceInformationProvider(context.getPropertiesProvider()));
        context.addExceptionMapper((ExceptionMapper)new OptimisticLockExceptionMapper());
        context.addExceptionMapper((ExceptionMapper)new PersistenceExceptionMapper(context));
        context.addExceptionMapper((ExceptionMapper)new PersistenceRollbackExceptionMapper(context));
        this.addHibernateConstraintViolationExceptionMapper();
        this.addTransactionRollbackExceptionMapper();
        context.addRepositoryDecoratorFactory((RepositoryDecoratorFactory)new JpaRepositoryDecoratorFactory());
        if (this.em != null) {
            this.metaEnricher = new JpaMetaEnricher();
            MetaModuleExtension metaModuleExtension = new MetaModuleExtension();
            metaModuleExtension.addProvider(this.metaEnricher.getProvider());
            context.addExtension((ModuleExtension)metaModuleExtension);
            this.setupTransactionMgmt();
        }
    }

    private void initQueryFactory() {
        JpaQueryFactory queryFactory = this.config.getQueryFactory();
        queryFactory.initalize(new JpaQueryFactoryContext(){

            @Override
            public EntityManager getEntityManager() {
                return JpaModule.this.em;
            }

            @Override
            public MetaPartition getMetaPartition() {
                return JpaModule.this.jpaMetaProvider.getPartition();
            }
        });
        if (queryFactory instanceof QuerydslQueryFactory) {
            QuerydslQueryFactory querydslFactory = (QuerydslQueryFactory)queryFactory;
            querydslFactory.addInterceptor(new JpaQuerydslTranslationInterceptor());
        }
    }

    public void init() {
        if (this.em != null) {
            this.setupServerRepositories();
        }
    }

    private void addHibernateConstraintViolationExceptionMapper() {
        if (ClassUtils.existsClass((String)"org.hibernate.exception.ConstraintViolationException")) {
            ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Class<?> mapperClass = Class.forName("io.crnk.jpa.internal.HibernateConstraintViolationExceptionMapper");
                    Constructor<?> constructor = mapperClass.getConstructor(new Class[0]);
                    ExceptionMapper mapper = (ExceptionMapper)constructor.newInstance(new Object[0]);
                    JpaModule.this.context.addExceptionMapper(mapper);
                    return null;
                }
            });
        }
    }

    private void addTransactionRollbackExceptionMapper() {
        if (ClassUtils.existsClass((String)"javax.transaction.RollbackException")) {
            ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Class<?> mapperClass = Class.forName("io.crnk.jpa.internal.TransactionRollbackExceptionMapper");
                    Constructor<?> constructor = mapperClass.getConstructor(Module.ModuleContext.class);
                    ExceptionMapper mapper = (ExceptionMapper)constructor.newInstance(JpaModule.this.context);
                    JpaModule.this.context.addExceptionMapper(mapper);
                    return null;
                }
            });
        }
    }

    protected void setupTransactionMgmt() {
        this.context.addFilter((DocumentFilter)new AbstractDocumentFilter(){

            public Response filter(final DocumentFilterContext context, final DocumentFilterChain chain) {
                return (Response)JpaModule.this.transactionRunner.doInTransaction((Callable)new Callable<Response>(){

                    @Override
                    public Response call() throws Exception {
                        return chain.doFilter(context);
                    }
                });
            }
        });
    }

    private void setupServerRepositories() {
        this.metaEnricher.setMetaProvider(this.jpaMetaProvider);
        for (JpaRepositoryConfig config : this.config.getRepositories()) {
            this.setupRepository(config);
        }
    }

    private void setupRepository(JpaRepositoryConfig<?> repositoryConfig) {
        if (repositoryConfig.getListMetaClass() == DefaultPagedMetaInformation.class && !this.isTotalResourceCountUsed()) {
            repositoryConfig.setListMetaClass(DefaultHasMoreResourcesMetaInformation.class);
        }
        Class<?> resourceClass = repositoryConfig.getResourceClass();
        MetaEntity metaEntity = (MetaEntity)((Object)this.jpaMetaProvider.getMeta(repositoryConfig.getEntityClass()));
        if (this.isValidEntity(metaEntity)) {
            JpaRepositoryFactory repositoryFactory = this.config.getRepositoryFactory();
            JpaEntityRepository jpaRepository = repositoryFactory.createEntityRepository(this, repositoryConfig);
            ResourceRepositoryV2<?, ?> repository = this.filterResourceCreation(resourceClass, jpaRepository);
            this.context.addRepository(repository);
            this.setupRelationshipRepositories(resourceClass, repositoryConfig.getResourceClass() != repositoryConfig.getEntityClass());
        }
    }

    private ResourceRepositoryV2<?, ?> filterResourceCreation(Class<?> resourceClass, JpaEntityRepository<?, ?> repository) {
        JpaEntityRepository<?, ?> filteredRepository = repository;
        for (JpaRepositoryFilter filter : this.config.getFilters()) {
            if (!filter.accept(resourceClass)) continue;
            filteredRepository = filter.filterCreation(filteredRepository);
        }
        return filteredRepository;
    }

    private RelationshipRepositoryV2<?, ?, ?, ?> filterRelationshipCreation(Class<?> resourceClass, JpaRelationshipRepository<?, ?, ?, ?> repository) {
        JpaRelationshipRepository<?, ?, ?, ?> filteredRepository = repository;
        for (JpaRepositoryFilter filter : this.config.getFilters()) {
            if (!filter.accept(resourceClass)) continue;
            filteredRepository = filter.filterCreation(filteredRepository);
        }
        return filteredRepository;
    }

    private void setupRelationshipRepositories(Class<?> resourceClass, boolean mapped) {
        if (this.context.getResourceInformationBuilder().accept(resourceClass)) {
            ResourceInformation information = this.context.getResourceInformationBuilder().build(resourceClass);
            for (ResourceField field : information.getFields()) {
                boolean isEntity;
                if (field.getResourceFieldType() != ResourceFieldType.RELATIONSHIP) continue;
                Class attrType = field.getElementType();
                boolean bl = isEntity = attrType.getAnnotation(Entity.class) != null;
                if (isEntity) {
                    this.setupRelationshipRepositoryForEntity(resourceClass, field);
                    continue;
                }
                this.setupRelationshipRepositoryForResource(resourceClass, field);
            }
        }
    }

    private void setupRelationshipRepositoryForEntity(Class<?> resourceClass, ResourceField field) {
        Class attrType = field.getElementType();
        JpaRepositoryConfig attrConfig = this.getRepositoryConfig(attrType);
        if (attrConfig != null) {
            JpaRepositoryFactory repositoryFactory = this.config.getRepositoryFactory();
            RelationshipRepositoryV2<?, ?, ?, ?> relationshipRepository = this.filterRelationshipCreation(attrType, repositoryFactory.createRelationshipRepository(this, field, attrConfig));
            this.context.addRepository(relationshipRepository);
        }
    }

    private void setupRelationshipRepositoryForResource(Class<?> resourceClass, ResourceField field) {
        Class attrImplClass = field.getElementType();
        JpaRepositoryConfig attrConfig = this.getRepositoryConfig(attrImplClass);
        if (attrConfig != null) {
            PreconditionUtil.verify((attrConfig.getMapper() != null ? 1 : 0) != 0, (String)"no mapped entity %s referenced from %s.%s registered", (Object[])new Object[]{attrImplClass.getName(), field.getParentResourceInformation().getResourceType(), field.getUnderlyingName()});
            JpaRepositoryConfig targetConfig = this.getRepositoryConfig(attrImplClass);
            Class targetResourceClass = targetConfig.getResourceClass();
            JpaRepositoryFactory repositoryFactory = this.config.getRepositoryFactory();
            RelationshipRepositoryV2<?, ?, ?, ?> relationshipRepository = this.filterRelationshipCreation(targetResourceClass, repositoryFactory.createRelationshipRepository(this, field, attrConfig));
            this.context.addRepository(relationshipRepository);
        }
    }

    private boolean isValidEntity(MetaEntity metaEntity) {
        if (metaEntity.getPrimaryKey() == null) {
            this.logger.warn("{} has no primary key and will be ignored", (Object)metaEntity.getName());
            return false;
        }
        if (metaEntity.getPrimaryKey().getElements().size() > 1) {
            this.logger.warn("{} has a compound primary key and will be ignored", (Object)metaEntity.getName());
            return false;
        }
        return true;
    }

    public ResourceInformationProvider getResourceInformationProvider(PropertiesProvider propertiesProvider) {
        if (this.resourceInformationProvider == null) {
            this.resourceInformationProvider = new JpaResourceInformationProvider(propertiesProvider);
        }
        return this.resourceInformationProvider;
    }

    public void setResourceInformationProvider(ResourceInformationProvider resourceInformationProvider) {
        PreconditionUtil.verify((this.resourceInformationProvider == null ? 1 : 0) != 0, (String)"already set", (Object[])new Object[0]);
        this.resourceInformationProvider = resourceInformationProvider;
    }

    @Deprecated
    public JpaQueryFactory getQueryFactory() {
        return this.config.getQueryFactory();
    }

    @Deprecated
    public void setQueryFactory(JpaQueryFactory queryFactory) {
        this.config.setQueryFactory(queryFactory);
        if (this.context != null) {
            this.initQueryFactory();
        }
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emFactory;
    }

    @Deprecated
    public <T> JpaRepositoryConfig<T> getRepositoryConfig(Class<T> resourceClass) {
        return this.config.getRepository(resourceClass);
    }

    public MetaLookup getJpaMetaLookup() {
        return this.jpaMetaLookup;
    }

    @Deprecated
    public boolean isTotalResourceCountUsed() {
        return this.config.isTotalResourceCountUsed();
    }

    public void setTotalResourceCountUsed(boolean totalResourceCountUsed) {
        this.config.setTotalResourceCountUsed(totalResourceCountUsed);
    }

    public boolean hasRepository(Class<?> resourceClass) {
        return this.config.hasRepository(resourceClass);
    }

    public JpaMetaProvider getJpaMetaProvider() {
        return this.jpaMetaProvider;
    }

    class JpaRepositoryDecoratorFactory
    implements RepositoryDecoratorFactory {
        JpaRepositoryDecoratorFactory() {
        }

        public <T, I extends Serializable> ResourceRepositoryDecorator<T, I> decorateRepository(ResourceRepositoryV2<T, I> repository) {
            JpaRepositoryConfig config;
            if (repository instanceof JpaRepositoryBase && (config = JpaModule.this.getRepositoryConfig(repository.getResourceClass())) != null) {
                return config.getRepositoryDecorator();
            }
            return null;
        }

        public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryDecorator<T, I, D, J> decorateRepository(RelationshipRepositoryV2<T, I, D, J> repository) {
            JpaRepositoryConfig config;
            if (repository instanceof JpaRepositoryBase && (config = JpaModule.this.getRepositoryConfig(repository.getSourceResourceClass())) != null) {
                return config.getRepositoryDecorator(repository.getTargetResourceClass());
            }
            return null;
        }
    }

    private final class JpaQuerydslTranslationInterceptor
    implements QuerydslTranslationInterceptor {
        private JpaQuerydslTranslationInterceptor() {
        }

        @Override
        public <T> void intercept(QuerydslQueryImpl<T> query, QuerydslTranslationContext<T> translationContext) {
            JpaRequestContext requestContext = (JpaRequestContext)query.getPrivateData();
            if (requestContext != null) {
                for (JpaRepositoryFilter filter : JpaModule.this.config.getFilters()) {
                    this.invokeFilter(filter, requestContext, translationContext);
                }
            }
        }

        private <T> void invokeFilter(JpaRepositoryFilter filter, JpaRequestContext requestContext, QuerydslTranslationContext<T> translationContext) {
            if (filter instanceof QuerydslRepositoryFilter) {
                Object repository = requestContext.getRepository();
                QuerySpec querySpec = requestContext.getQuerySpec();
                ((QuerydslRepositoryFilter)filter).filterQueryTranslation(repository, querySpec, translationContext);
            }
        }
    }
}

