/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa;

import io.crnk.jpa.DefaultJpaRepositoryFactory;
import io.crnk.jpa.JpaRepositoryConfig;
import io.crnk.jpa.JpaRepositoryFactory;
import io.crnk.jpa.JpaRepositoryFilter;
import io.crnk.jpa.internal.QueryFactoryDiscovery;
import io.crnk.jpa.query.JpaQueryFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.ManagedType;

public class JpaModuleConfig {
    private JpaQueryFactory queryFactory;
    private List<JpaRepositoryFilter> filters = new CopyOnWriteArrayList<JpaRepositoryFilter>();
    private boolean totalResourceCountUsed = true;
    private JpaRepositoryFactory repositoryFactory = new DefaultJpaRepositoryFactory();
    private Map<Class<?>, JpaRepositoryConfig<?>> repositoryConfigurationMap = new HashMap();

    public JpaModuleConfig() {
        QueryFactoryDiscovery queryFactoryDiscovery = new QueryFactoryDiscovery();
        this.setQueryFactory(queryFactoryDiscovery.discoverDefaultFactory());
    }

    public void setRepositoryFactory(JpaRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public JpaRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void addFilter(JpaRepositoryFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(JpaRepositoryFilter filter) {
        this.filters.remove(filter);
    }

    public List<JpaRepositoryFilter> getFilters() {
        return this.filters;
    }

    public boolean isTotalResourceCountUsed() {
        return this.totalResourceCountUsed;
    }

    public void setTotalResourceCountUsed(boolean totalResourceCountUsed) {
        this.totalResourceCountUsed = totalResourceCountUsed;
    }

    public boolean hasRepository(Class<?> resourceClass) {
        return this.repositoryConfigurationMap.containsKey(resourceClass);
    }

    public <T> JpaRepositoryConfig<T> getRepository(Class<T> resourceClass) {
        return this.repositoryConfigurationMap.get(resourceClass);
    }

    public Collection<JpaRepositoryConfig> getRepositories() {
        return this.repositoryConfigurationMap.values();
    }

    public <T> void addRepository(JpaRepositoryConfig<T> config) {
        Class<T> resourceClass = config.getResourceClass();
        if (this.repositoryConfigurationMap.containsKey(resourceClass)) {
            throw new IllegalStateException(resourceClass.getName() + " is already registered");
        }
        this.repositoryConfigurationMap.put(resourceClass, config);
    }

    public void exposeAllEntities(EntityManagerFactory emf) {
        Set managedTypes = emf.getMetamodel().getManagedTypes();
        for (ManagedType managedType : managedTypes) {
            Class managedJavaType = managedType.getJavaType();
            if (managedJavaType.getAnnotation(Entity.class) == null) continue;
            this.addRepository(JpaRepositoryConfig.builder(managedJavaType).build());
        }
    }

    public <T> void removeRepository(Class<T> resourceClass) {
        this.repositoryConfigurationMap.remove(resourceClass);
    }

    public void removeRepositories() {
        this.repositoryConfigurationMap.clear();
    }

    public Set<Class<?>> getResourceClasses() {
        return Collections.unmodifiableSet(this.repositoryConfigurationMap.keySet());
    }

    public JpaQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public void setQueryFactory(JpaQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }
}

