/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.BulkRelationshipRepositoryV2;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import io.crnk.jpa.JpaModule;
import io.crnk.jpa.JpaRepositoryConfig;
import io.crnk.jpa.internal.JpaRepositoryBase;
import io.crnk.jpa.internal.JpaRepositoryUtils;
import io.crnk.jpa.internal.JpaRequestContext;
import io.crnk.jpa.mapping.JpaMapper;
import io.crnk.jpa.meta.MetaEntity;
import io.crnk.jpa.query.ComputedAttributeRegistry;
import io.crnk.jpa.query.JpaQuery;
import io.crnk.jpa.query.JpaQueryExecutor;
import io.crnk.jpa.query.JpaQueryFactory;
import io.crnk.jpa.query.Tuple;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class JpaRelationshipRepository<S, I extends Serializable, T, J extends Serializable>
extends JpaRepositoryBase<T>
implements RelationshipRepositoryV2<S, I, T, J>,
BulkRelationshipRepositoryV2<S, I, T, J> {
    private final ResourceField resourceField;
    private Class<S> sourceResourceClass;
    private Class<?> sourceEntityClass;
    private MetaEntity entityMeta;
    private JpaMapper<?, S> sourceMapper;

    public JpaRelationshipRepository(JpaModule module, ResourceField resourceField, JpaRepositoryConfig<T> repositoryConfig) {
        super(module, repositoryConfig);
        this.sourceResourceClass = resourceField.getParentResourceInformation().getResourceClass();
        this.resourceField = resourceField;
        JpaRepositoryConfig<S> sourceMapping = module.getRepositoryConfig(this.sourceResourceClass);
        this.sourceEntityClass = sourceMapping.getEntityClass();
        this.sourceMapper = sourceMapping.getMapper();
        this.entityMeta = (MetaEntity)((Object)module.getJpaMetaProvider().getMeta(this.sourceEntityClass));
    }

    public RelationshipMatcher getMatcher() {
        return new RelationshipMatcher().rule().field(this.resourceField).add();
    }

    public void setRelation(S source, J targetId, String fieldName) {
        MetaAttribute attrMeta = this.entityMeta.getAttribute(fieldName);
        MetaAttribute oppositeAttrMeta = attrMeta.getOppositeAttribute();
        Class<?> targetType = this.getElementType(attrMeta);
        Object sourceEntity = this.sourceMapper.unmap(source);
        EntityManager em = this.module.getEntityManager();
        Object target = targetId != null ? em.find(targetType, targetId) : null;
        attrMeta.setValue(sourceEntity, target);
        if (target != null && oppositeAttrMeta != null) {
            if (oppositeAttrMeta.getType().isCollection()) {
                oppositeAttrMeta.addValue(target, sourceEntity);
            } else {
                oppositeAttrMeta.setValue(target, sourceEntity);
            }
            em.persist(target);
        }
    }

    public void setRelations(S source, Iterable<J> targetIds, String fieldName) {
        MetaAttribute attrMeta = this.entityMeta.getAttribute(fieldName);
        MetaAttribute oppositeAttrMeta = attrMeta.getOppositeAttribute();
        Class<?> targetType = this.getElementType(attrMeta);
        Object sourceEntity = this.sourceMapper.unmap(source);
        EntityManager em = this.module.getEntityManager();
        Collection targets = attrMeta.getType().asCollection().newInstance();
        for (Serializable targetId : targetIds) {
            Object target = em.find(targetType, (Object)targetId);
            targets.add(target);
        }
        if (oppositeAttrMeta != null) {
            Collection col = (Collection)attrMeta.getValue(sourceEntity);
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                Object prevTarget = iterator.next();
                iterator.remove();
                if (oppositeAttrMeta.getType().isCollection()) {
                    oppositeAttrMeta.removeValue(prevTarget, sourceEntity);
                    continue;
                }
                oppositeAttrMeta.setValue(prevTarget, null);
            }
        }
        for (Object target : targets) {
            if (oppositeAttrMeta == null) continue;
            if (oppositeAttrMeta.getType().isCollection()) {
                oppositeAttrMeta.addValue(target, sourceEntity);
            } else {
                oppositeAttrMeta.setValue(target, sourceEntity);
            }
            em.persist(target);
        }
        attrMeta.setValue(sourceEntity, (Object)targets);
    }

    private Class<?> getElementType(MetaAttribute attrMeta) {
        MetaType type = attrMeta.getType();
        if (type.isCollection()) {
            return type.asCollection().getElementType().getImplementationClass();
        }
        return type.getImplementationClass();
    }

    public void addRelations(S source, Iterable<J> targetIds, String fieldName) {
        MetaAttribute attrMeta = this.entityMeta.getAttribute(fieldName);
        MetaAttribute oppositeAttrMeta = attrMeta.getOppositeAttribute();
        Class<?> targetType = this.getElementType(attrMeta);
        Object sourceEntity = this.sourceMapper.unmap(source);
        EntityManager em = this.module.getEntityManager();
        for (Serializable targetId : targetIds) {
            Object target = em.find(targetType, (Object)targetId);
            attrMeta.addValue(sourceEntity, target);
            if (oppositeAttrMeta == null) continue;
            if (oppositeAttrMeta.getType().isCollection()) {
                oppositeAttrMeta.addValue(target, sourceEntity);
            } else {
                oppositeAttrMeta.setValue(target, sourceEntity);
            }
            em.persist(target);
        }
        em.persist(sourceEntity);
    }

    public void removeRelations(S source, Iterable<J> targetIds, String fieldName) {
        MetaAttribute attrMeta = this.entityMeta.getAttribute(fieldName);
        MetaAttribute oppositeAttrMeta = attrMeta.getOppositeAttribute();
        Class<?> targetType = this.getElementType(attrMeta);
        Object sourceEntity = this.sourceMapper.unmap(source);
        EntityManager em = this.module.getEntityManager();
        for (Serializable targetId : targetIds) {
            Object target = em.find(targetType, (Object)targetId);
            attrMeta.removeValue(sourceEntity, target);
            if (target == null || oppositeAttrMeta == null) continue;
            if (oppositeAttrMeta.getType().isCollection()) {
                oppositeAttrMeta.removeValue(target, sourceEntity);
                continue;
            }
            oppositeAttrMeta.setValue(target, null);
        }
    }

    public MultivaluedMap<I, T> findTargets(Iterable<I> sourceIds, String fieldName, QuerySpec querySpec) {
        ArrayList<Serializable> sourceIdLists = new ArrayList<Serializable>();
        for (Serializable sourceId : sourceIds) {
            sourceIdLists.add(sourceId);
        }
        if (querySpec.getLimit() != null && sourceIdLists.size() > 1) {
            throw new UnsupportedOperationException("page limit not supported for bulk inclusions");
        }
        boolean singleRequest = sourceIdLists.size() == 1;
        boolean pagedSingleRequest = singleRequest && querySpec.getLimit() != null;
        boolean fetchNext = pagedSingleRequest && this.isNextFetched(querySpec);
        QuerySpec bulkQuerySpec = querySpec.duplicate();
        QuerySpec filteredQuerySpec = this.filterQuerySpec(bulkQuerySpec);
        JpaQueryFactory queryFactory = this.module.getQueryFactory();
        JpaQuery query = queryFactory.query(this.sourceEntityClass, fieldName, sourceIdLists);
        query.setPrivateData(new JpaRequestContext(this, querySpec));
        query.addParentIdSelection();
        query = this.filterQuery(filteredQuerySpec, query);
        Class<?> entityClass = this.repositoryConfig.getEntityClass();
        ComputedAttributeRegistry computedAttributesRegistry = queryFactory.getComputedAttributes();
        Set<String> computedAttrs = computedAttributesRegistry.getForType(entityClass);
        JpaRepositoryUtils.prepareQuery(query, filteredQuerySpec, computedAttrs);
        JpaQueryExecutor executor = query.buildExecutor();
        JpaRepositoryUtils.prepareExecutor(executor, filteredQuerySpec, this.fetchRelations(fieldName));
        executor = this.filterExecutor(filteredQuerySpec, executor);
        if (fetchNext) {
            executor.setLimit(executor.getLimit() + 1);
        }
        List<Tuple> tuples = executor.getResultTuples();
        Boolean hasNext = null;
        if (fetchNext && (hasNext = Boolean.valueOf((long)tuples.size() == querySpec.getLimit() + 1L)).booleanValue()) {
            tuples = tuples.subList(0, querySpec.getLimit().intValue());
        }
        tuples = this.filterTuples(bulkQuerySpec, tuples);
        MultivaluedMap<I, T> map = this.mapTuples(tuples);
        if (singleRequest) {
            ResourceList iterable;
            Serializable sourceId = (Serializable)sourceIdLists.get(0);
            if (map.containsKey((Object)sourceId)) {
                iterable = (ResourceList)map.getList((Object)sourceId);
            } else {
                iterable = this.repositoryConfig.newResultList();
                map.set((Object)sourceId, (List)iterable);
            }
            if (pagedSingleRequest) {
                MetaInformation metaInfo = iterable.getMeta();
                boolean fetchTotal = this.isTotalFetched(filteredQuerySpec);
                if (fetchTotal) {
                    long totalRowCount = executor.getTotalRowCount();
                    ((PagedMetaInformation)metaInfo).setTotalResourceCount(Long.valueOf(totalRowCount));
                }
                if (fetchNext) {
                    ((HasMoreResourcesMetaInformation)metaInfo).setHasMoreResources(hasNext);
                }
            }
        }
        return map;
    }

    private MultivaluedMap<I, T> mapTuples(List<Tuple> tuples) {
        MultivaluedMap map = new MultivaluedMap<I, T>(){

            protected List<T> newList() {
                return JpaRelationshipRepository.this.repositoryConfig.newResultList();
            }
        };
        for (Tuple tuple : tuples) {
            Serializable sourceId = (Serializable)tuple.get(0, Object.class);
            tuple.reduce(1);
            JpaMapper mapper = this.repositoryConfig.getMapper();
            map.add((Object)sourceId, mapper.map(tuple));
        }
        return map;
    }

    public T findOneTarget(I sourceId, String fieldName, QuerySpec querySpec) {
        MultivaluedMap<Serializable, T> map = this.findTargets(Arrays.asList(sourceId), fieldName, querySpec);
        if (!map.containsKey(sourceId)) {
            return null;
        }
        List list = map.getList(sourceId);
        return (T)(list.isEmpty() ? null : map.getUnique(sourceId));
    }

    public ResourceList<T> findManyTargets(I sourceId, String fieldName, QuerySpec querySpec) {
        MultivaluedMap<Serializable, T> map = this.findTargets(Arrays.asList(sourceId), fieldName, querySpec);
        PreconditionUtil.assertTrue((String)"result must always include request for single element", (boolean)map.containsKey(sourceId));
        return (ResourceList)map.getList(sourceId);
    }

    public Class<S> getSourceResourceClass() {
        return this.sourceResourceClass;
    }

    public Class<T> getTargetResourceClass() {
        return this.repositoryConfig.getResourceClass();
    }

    public Class<?> getTargetEntityClass() {
        return this.repositoryConfig.getEntityClass();
    }
}

