/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.decorate.RelationshipRepositoryDecorator;
import io.crnk.core.repository.decorate.ResourceRepositoryDecorator;
import io.crnk.core.resource.links.DefaultPagedLinksInformation;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceListBase;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.jpa.mapping.IdentityMapper;
import io.crnk.jpa.mapping.JpaMapper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.jodah.typetools.TypeResolver;

public class JpaRepositoryConfig<T> {
    private Class<?> entityClass;
    private Class<T> resourceClass;
    private JpaMapper<?, T> mapper;
    private Class<? extends DefaultResourceList<T>> listClass;
    private Class<? extends MetaInformation> listMetaClass;
    private Class<? extends LinksInformation> listLinksClass;
    private ResourceRepositoryDecorator<T, ?> resourceRepositoryDecorator;
    private Map<Class<?>, RelationshipRepositoryDecorator<T, ?, ?, ?>> relationshipRepositoriesDecorators;

    private JpaRepositoryConfig() {
    }

    public static <E> JpaRepositoryConfig<E> create(Class<E> entityClass) {
        return JpaRepositoryConfig.builder(entityClass).build();
    }

    public static <E> Builder<E> builder(Class<E> entityClass) {
        Builder builder = new Builder();
        builder.entityClass = entityClass;
        builder.resourceClass = entityClass;
        return builder;
    }

    public static <E, D> Builder<D> builder(Class<E> entityClass, Class<D> dtoClass, JpaMapper<E, D> mapper) {
        Builder builder = new Builder();
        builder.entityClass = entityClass;
        builder.resourceClass = dtoClass;
        builder.mapper = mapper;
        return builder;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    public Class<? extends MetaInformation> getListMetaClass() {
        return this.listMetaClass;
    }

    public Class<? extends LinksInformation> getListLinksClass() {
        return this.listLinksClass;
    }

    public <E> JpaMapper<E, T> getMapper() {
        return this.mapper;
    }

    public <M extends MetaInformation, L extends LinksInformation> Class<? extends ResourceListBase<T, M, L>> getListClass() {
        return this.listClass;
    }

    public DefaultResourceList<T> newResultList() {
        DefaultResourceList list = (DefaultResourceList)ClassUtils.newInstance(this.listClass);
        list.setMeta(this.newMetaInformation());
        list.setLinks(this.newLinksInformation());
        return list;
    }

    private MetaInformation newMetaInformation() {
        if (this.listMetaClass != null) {
            return (MetaInformation)ClassUtils.newInstance(this.listMetaClass);
        }
        return null;
    }

    private LinksInformation newLinksInformation() {
        if (this.listLinksClass != null) {
            return (LinksInformation)ClassUtils.newInstance(this.listLinksClass);
        }
        return null;
    }

    public <I extends Serializable> ResourceRepositoryDecorator<T, I> getRepositoryDecorator() {
        return this.resourceRepositoryDecorator;
    }

    public <D, I extends Serializable, J extends Serializable> RelationshipRepositoryDecorator<T, I, D, J> getRepositoryDecorator(Class<D> targetResourceType) {
        return this.relationshipRepositoriesDecorators.get(targetResourceType);
    }

    protected void setListMetaClass(Class<? extends MetaInformation> listMetaClass) {
        this.listMetaClass = listMetaClass;
    }

    public static class Builder<T> {
        private Class<?> entityClass;
        private Class<T> resourceClass;
        private JpaMapper<?, T> mapper = IdentityMapper.newInstance();
        private Class<? extends DefaultResourceList<T>> listClass = DefaultResourceList.class;
        private Class<? extends MetaInformation> listMetaClass = DefaultPagedMetaInformation.class;
        private Class<? extends LinksInformation> listLinksClass = DefaultPagedLinksInformation.class;
        private ResourceRepositoryDecorator<T, ?> resourceRepositoryDecorator;
        private Map<Class<?>, RelationshipRepositoryDecorator<T, ?, ?, ?>> relationshipRepositoryDecorators = new HashMap();

        public JpaRepositoryConfig<T> build() {
            JpaRepositoryConfig config = new JpaRepositoryConfig();
            config.entityClass = this.entityClass;
            config.resourceClass = this.resourceClass;
            config.mapper = this.mapper;
            config.listClass = this.listClass;
            config.listMetaClass = this.listMetaClass;
            config.listLinksClass = this.listLinksClass;
            config.resourceRepositoryDecorator = this.resourceRepositoryDecorator;
            config.relationshipRepositoriesDecorators = this.relationshipRepositoryDecorators;
            return config;
        }

        public Builder<T> setInterfaceClass(Class<? extends ResourceRepositoryV2<T, ?>> interfaceClass) {
            try {
                Method findMethod = interfaceClass.getDeclaredMethod("findAll", QuerySpec.class);
                Class<?> returnType = findMethod.getReturnType();
                if (!ResourceListBase.class.isAssignableFrom(returnType)) {
                    throw new IllegalStateException("findAll return type must extend " + ResourceListBase.class.getName());
                }
                this.setListClass(returnType);
                Class[] typeArgs = TypeResolver.resolveRawArguments(ResourceListBase.class, returnType);
                this.setListMetaClass(typeArgs[1]);
                this.setListLinksClass(typeArgs[2]);
                return this;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("findAll method not overriden by " + interfaceClass.getName(), e);
            }
        }

        public Builder<T> setListClass(Class<? extends DefaultResourceList<T>> listClass) {
            this.listClass = listClass;
            return this;
        }

        public Builder<T> setListMetaClass(Class<? extends MetaInformation> listMetaClass) {
            this.listMetaClass = listMetaClass;
            return this;
        }

        public Builder<T> setListLinksClass(Class<? extends LinksInformation> listLinksClass) {
            this.listLinksClass = listLinksClass;
            return this;
        }

        public Builder<T> setRepositoryDecorator(ResourceRepositoryDecorator<T, ?> decoratorResourceRepository) {
            this.resourceRepositoryDecorator = decoratorResourceRepository;
            return this;
        }

        public <D> Builder<T> putRepositoryDecorator(Class<D> targetClass, RelationshipRepositoryDecorator<T, ?, D, ?> decoratorRelationshipRepository) {
            this.relationshipRepositoryDecorators.put(targetClass, decoratorRelationshipRepository);
            return this;
        }
    }
}

