/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.module.Module;
import io.crnk.core.utils.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWrappedExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Module.ModuleContext context;

    public AbstractWrappedExceptionMapper(Module.ModuleContext context) {
        this.context = context;
    }

    public ErrorResponse toErrorResponse(E exception) {
        Optional mapper;
        Throwable cause = ((Throwable)exception).getCause();
        if (cause != null && (mapper = this.context.getExceptionMapperRegistry().findMapperFor(cause.getClass())).isPresent()) {
            return ((JsonApiExceptionMapper)mapper.get()).toErrorResponse(cause);
        }
        this.LOGGER.error("failed to process request due to jpa exception", exception);
        int status = this.getStatus();
        ErrorData errorData = ErrorData.builder().setStatus(Integer.toString(status)).setTitle(((Throwable)exception).getMessage()).build();
        return ErrorResponse.builder().setSingleErrorData(errorData).setStatus(status).build();
    }

    protected int getStatus() {
        return 500;
    }

    public E fromErrorResponse(ErrorResponse errorResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean accepts(ErrorResponse errorResponse) {
        return false;
    }
}

