/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal;

import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import io.crnk.jpa.JpaModule;
import io.crnk.jpa.JpaRepositoryConfig;
import io.crnk.jpa.JpaRepositoryFilter;
import io.crnk.jpa.mapping.JpaMapper;
import io.crnk.jpa.query.JpaQuery;
import io.crnk.jpa.query.JpaQueryExecutor;
import io.crnk.jpa.query.Tuple;
import java.util.List;

public abstract class JpaRepositoryBase<T> {
    protected JpaModule module;
    protected JpaRepositoryConfig<T> repositoryConfig;

    protected <E> JpaRepositoryBase(JpaModule module, JpaRepositoryConfig<T> repositoryConfig) {
        this.module = module;
        this.repositoryConfig = repositoryConfig;
    }

    protected boolean isNextFetched(QuerySpec querySpec) {
        return querySpec.getLimit() != null && !this.module.isTotalResourceCountUsed() && this.repositoryConfig.getListMetaClass() != null && HasMoreResourcesMetaInformation.class.isAssignableFrom(this.repositoryConfig.getListMetaClass());
    }

    protected boolean isTotalFetched(QuerySpec querySpec) {
        return querySpec.getLimit() != null && this.module.isTotalResourceCountUsed() && this.repositoryConfig.getListMetaClass() != null && PagedMetaInformation.class.isAssignableFrom(this.repositoryConfig.getListMetaClass());
    }

    protected static <D> D getUnique(List<D> list, Object id) {
        if (list.isEmpty()) {
            throw new ResourceNotFoundException("resource not found: id=" + id);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new IllegalStateException("unique result expected");
    }

    protected boolean fetchRelations(String fieldName) {
        return false;
    }

    protected QuerySpec filterQuerySpec(QuerySpec querySpec) {
        QuerySpec filteredQuerySpec = querySpec;
        for (JpaRepositoryFilter filter : this.module.getFilters()) {
            if (!filter.accept(this.repositoryConfig.getResourceClass())) continue;
            filteredQuerySpec = filter.filterQuerySpec(this, filteredQuerySpec);
        }
        return filteredQuerySpec;
    }

    protected <E> JpaQuery<E> filterQuery(QuerySpec querySpec, JpaQuery<E> query) {
        JpaQuery<E> filteredQuery = query;
        for (JpaRepositoryFilter filter : this.module.getFilters()) {
            if (!filter.accept(this.repositoryConfig.getResourceClass())) continue;
            filteredQuery = filter.filterQuery(this, querySpec, filteredQuery);
        }
        return filteredQuery;
    }

    protected <E> JpaQueryExecutor<E> filterExecutor(QuerySpec querySpec, JpaQueryExecutor<E> executor) {
        JpaQueryExecutor<E> filteredExecutor = executor;
        for (JpaRepositoryFilter filter : this.module.getFilters()) {
            if (!filter.accept(this.repositoryConfig.getResourceClass())) continue;
            filteredExecutor = filter.filterExecutor(this, querySpec, filteredExecutor);
        }
        return filteredExecutor;
    }

    protected List<Tuple> filterTuples(QuerySpec querySpec, List<Tuple> tuples) {
        List<Tuple> filteredTuples = tuples;
        for (JpaRepositoryFilter filter : this.module.getFilters()) {
            if (!filter.accept(this.repositoryConfig.getResourceClass())) continue;
            filteredTuples = filter.filterTuples(this, querySpec, filteredTuples);
        }
        return filteredTuples;
    }

    protected ResourceList<T> filterResults(QuerySpec querySpec, ResourceList<T> resources) {
        ResourceList<T> filteredResources = resources;
        for (JpaRepositoryFilter filter : this.module.getFilters()) {
            if (!filter.accept(this.repositoryConfig.getResourceClass())) continue;
            filteredResources = filter.filterResults(this, querySpec, filteredResources);
        }
        return filteredResources;
    }

    protected ResourceList<T> fillResourceList(List<Tuple> tuples, ResourceList<T> resources) {
        for (Tuple tuple : tuples) {
            JpaMapper mapper = this.repositoryConfig.getMapper();
            resources.add(mapper.map(tuple));
        }
        return resources;
    }
}

