/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.jpa.query.JpaQuery;
import io.crnk.jpa.query.JpaQueryExecutor;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaPrimaryKey;
import java.util.Arrays;
import java.util.Set;

public class JpaRepositoryUtils {
    private JpaRepositoryUtils() {
    }

    public static MetaAttribute getPrimaryKeyAttr(MetaDataObject meta) {
        MetaPrimaryKey primaryKey = meta.getPrimaryKey();
        PreconditionUtil.assertNotNull((String)"no primary key", (Object)primaryKey);
        PreconditionUtil.assertEquals((String)"non-compound primary key expected", (Object)1, (Object)primaryKey.getElements().size());
        return (MetaAttribute)primaryKey.getElements().get(0);
    }

    public static void prepareQuery(JpaQuery<?> query, QuerySpec querySpec, Set<String> computedAttrs) {
        for (String computedAttr : computedAttrs) {
            query.addSelection(Arrays.asList(computedAttr));
        }
        for (FilterSpec filter : querySpec.getFilters()) {
            query.addFilter(filter);
        }
        for (SortSpec sortSpec : querySpec.getSort()) {
            query.addSortBy(sortSpec);
        }
        if (!querySpec.getIncludedFields().isEmpty()) {
            throw new UnsupportedOperationException("includeFields not yet supported");
        }
    }

    public static void prepareExecutor(JpaQueryExecutor<?> executor, QuerySpec querySpec, boolean includeRelations) {
        if (includeRelations) {
            for (IncludeSpec included : querySpec.getIncludedRelations()) {
                executor.fetch(included.getAttributePath());
            }
        }
        executor.setOffset((int)querySpec.getOffset());
        if (querySpec.getOffset() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("offset cannot be larger than Integer.MAX_VALUE");
        }
        if (querySpec.getLimit() != null) {
            if (querySpec.getLimit() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("limit cannot be larger than Integer.MAX_VALUE");
            }
            executor.setLimit((int)querySpec.getLimit().longValue());
        }
    }
}

