/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal;

import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.resource.ResourceFieldInformationProviderBase;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.core.utils.Optional;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;

public class JpaResourceFieldInformationProvider
extends ResourceFieldInformationProviderBase {
    public Optional<Boolean> isSortable(BeanAttributeInformation attributeDesc) {
        Optional lob = attributeDesc.getAnnotation(Lob.class);
        if (lob.isPresent()) {
            return Optional.of((Object)false);
        }
        return Optional.empty();
    }

    public Optional<Boolean> isFilterable(BeanAttributeInformation attributeDesc) {
        Optional lob = attributeDesc.getAnnotation(Lob.class);
        if (lob.isPresent()) {
            return Optional.of((Object)false);
        }
        return Optional.empty();
    }

    public Optional<Boolean> isPostable(BeanAttributeInformation attributeDesc) {
        Optional column = attributeDesc.getAnnotation(Column.class);
        Optional version = attributeDesc.getAnnotation(Version.class);
        if (!version.isPresent() && column.isPresent()) {
            return Optional.of((Object)((Column)column.get()).insertable());
        }
        Optional generatedValue = attributeDesc.getAnnotation(GeneratedValue.class);
        if (generatedValue.isPresent()) {
            return Optional.of((Object)false);
        }
        return Optional.empty();
    }

    public Optional<Boolean> isPatchable(BeanAttributeInformation attributeDesc) {
        Optional column = attributeDesc.getAnnotation(Column.class);
        Optional version = attributeDesc.getAnnotation(Version.class);
        if (!version.isPresent() && column.isPresent()) {
            return Optional.of((Object)((Column)column.get()).updatable());
        }
        Optional generatedValue = attributeDesc.getAnnotation(GeneratedValue.class);
        if (generatedValue.isPresent()) {
            return Optional.of((Object)false);
        }
        return Optional.empty();
    }

    public Optional<ResourceFieldType> getFieldType(BeanAttributeInformation attributeDesc) {
        Optional oneToOne = attributeDesc.getAnnotation(OneToOne.class);
        Optional oneToMany = attributeDesc.getAnnotation(OneToMany.class);
        Optional manyToOne = attributeDesc.getAnnotation(ManyToOne.class);
        Optional manyToMany = attributeDesc.getAnnotation(ManyToMany.class);
        if (oneToOne.isPresent() || oneToMany.isPresent() || manyToOne.isPresent() || manyToMany.isPresent()) {
            return Optional.of((Object)ResourceFieldType.RELATIONSHIP);
        }
        Optional id = attributeDesc.getAnnotation(Id.class);
        Optional embeddedId = attributeDesc.getAnnotation(EmbeddedId.class);
        if (id.isPresent() || embeddedId.isPresent()) {
            return Optional.of((Object)ResourceFieldType.ID);
        }
        return Optional.empty();
    }

    public Optional<String> getOppositeName(BeanAttributeInformation attributeDesc) {
        Optional oneToMany = attributeDesc.getAnnotation(OneToMany.class);
        if (oneToMany.isPresent()) {
            return Optional.ofNullable((Object)StringUtils.emptyToNull((String)((OneToMany)oneToMany.get()).mappedBy()));
        }
        Optional manyToMany = attributeDesc.getAnnotation(ManyToMany.class);
        if (manyToMany.isPresent()) {
            return Optional.ofNullable((Object)StringUtils.emptyToNull((String)((ManyToMany)manyToMany.get()).mappedBy()));
        }
        return Optional.empty();
    }

    public Optional<SerializeType> getSerializeType(BeanAttributeInformation attributeDesc) {
        Optional oneToMany = attributeDesc.getAnnotation(OneToMany.class);
        if (oneToMany.isPresent()) {
            return this.toSerializeType(((OneToMany)oneToMany.get()).fetch());
        }
        Optional manyToOne = attributeDesc.getAnnotation(ManyToOne.class);
        if (manyToOne.isPresent()) {
            return this.toSerializeType(((ManyToOne)manyToOne.get()).fetch());
        }
        Optional manyToMany = attributeDesc.getAnnotation(ManyToMany.class);
        if (manyToMany.isPresent()) {
            return this.toSerializeType(((ManyToMany)manyToMany.get()).fetch());
        }
        Optional elementCollection = attributeDesc.getAnnotation(ElementCollection.class);
        if (elementCollection.isPresent()) {
            return this.toSerializeType(((ElementCollection)elementCollection.get()).fetch());
        }
        return Optional.empty();
    }

    private Optional<SerializeType> toSerializeType(FetchType fetch) {
        return Optional.of((Object)(fetch == FetchType.EAGER ? SerializeType.ONLY_ID : SerializeType.LAZY));
    }
}

