/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceFieldInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProviderContext;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.information.resource.ResourceValidator;
import io.crnk.core.engine.internal.information.resource.DefaultResourceFieldInformationProvider;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceInformationProviderBase;
import io.crnk.core.engine.internal.jackson.JacksonResourceFieldInformationProvider;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.jpa.annotations.JpaResource;
import io.crnk.jpa.internal.JpaResourceFieldInformationProvider;
import io.crnk.jpa.meta.JpaMetaProvider;
import io.crnk.jpa.meta.MetaEntity;
import io.crnk.jpa.meta.MetaJpaDataObject;
import io.crnk.jpa.meta.internal.JpaMetaUtils;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaProvider;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.MappedSuperclass;
import javax.persistence.OptimisticLockException;

public class JpaResourceInformationProvider
extends ResourceInformationProviderBase {
    private static final String ENTITY_NAME_SUFFIX = "Entity";
    private final JpaMetaProvider metaProvider = new JpaMetaProvider(Collections.emptySet());

    public JpaResourceInformationProvider(PropertiesProvider propertiesProvider) {
        super(propertiesProvider, Arrays.asList(new ResourceFieldInformationProvider[]{new DefaultResourceFieldInformationProvider(), new JpaResourceFieldInformationProvider(), new JacksonResourceFieldInformationProvider()}));
        MetaLookup lookup = new MetaLookup();
        lookup.addProvider((MetaProvider)this.metaProvider);
        lookup.initialize();
        PreconditionUtil.assertNotNull((String)"must not be null", (Object)((Object)this.metaProvider));
    }

    public boolean accept(Class<?> resourceClass) {
        if (resourceClass.getAnnotation(JpaResource.class) != null) {
            return true;
        }
        if (JpaMetaUtils.isJpaType(resourceClass)) {
            Object meta = this.metaProvider.discoverMeta(resourceClass);
            if (meta instanceof MetaEntity) {
                MetaEntity metaEntity = (MetaEntity)((Object)meta);
                MetaPrimaryKey primaryKey = metaEntity.getPrimaryKey();
                return primaryKey != null && primaryKey.getElements().size() == 1;
            }
            return meta instanceof MetaJpaDataObject;
        }
        return false;
    }

    public ResourceInformation build(Class<?> resourceClass) {
        String resourceType = this.getResourceType(resourceClass);
        String resourcePath = this.getResourcePath(resourceClass);
        MetaDataObject meta = this.metaProvider.discoverMeta(resourceClass).asDataObject();
        DefaultResourceInstanceBuilder instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        List fields = this.getResourceFields(resourceClass);
        Class<?> superclass = resourceClass.getSuperclass();
        String superResourceType = superclass != Object.class && superclass.getAnnotation(MappedSuperclass.class) == null ? this.context.getResourceType(superclass) : null;
        TypeParser typeParser = this.context.getTypeParser();
        ResourceInformation info = new ResourceInformation(typeParser, resourceClass, resourceType, resourcePath, superResourceType, (ResourceInstanceBuilder)instanceBuilder, fields, (PagingBehavior)new OffsetLimitPagingBehavior());
        info.setValidator((ResourceValidator)new JpaOptimisticLockingValidator(meta));
        info.setIdStringMapper((StringMapper)new JpaIdMapper(meta));
        return info;
    }

    public String getResourceType(Class<?> entityClass) {
        JpaResource annotation = entityClass.getAnnotation(JpaResource.class);
        if (annotation != null) {
            return annotation.type();
        }
        if (entityClass.getAnnotation(MappedSuperclass.class) != null) {
            return null;
        }
        String name = entityClass.getSimpleName();
        if (name.endsWith(ENTITY_NAME_SUFFIX)) {
            name = name.substring(0, name.length() - ENTITY_NAME_SUFFIX.length());
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String getResourcePath(Class<?> entityClass) {
        return null;
    }

    protected LookupIncludeBehavior getDefaultLookupIncludeBehavior() {
        return LookupIncludeBehavior.AUTOMATICALLY_ALWAYS;
    }

    public void init(ResourceInformationProviderContext context) {
        super.init(context);
    }

    class JpaIdMapper
    implements StringMapper {
        private MetaDataObject jpaMeta;

        public JpaIdMapper(MetaDataObject jpaMeta) {
            this.jpaMeta = jpaMeta;
        }

        public String toString(Object input) {
            return this.jpaMeta.getPrimaryKey().toKeyString(input);
        }

        public Object parse(String input) {
            MetaPrimaryKey primaryKey = this.jpaMeta.getPrimaryKey();
            MetaAttribute attr = primaryKey.getUniqueElement();
            return (Serializable)this.fromKeyString(attr.getType(), input);
        }

        private Object fromKeyString(MetaType type, String idString) {
            if (type instanceof MetaDataObject) {
                return this.parseEmbeddableString((MetaDataObject)type, idString);
            }
            return JpaResourceInformationProvider.this.context.getTypeParser().parse(idString, type.getImplementationClass());
        }

        private Object parseEmbeddableString(MetaDataObject embType, String idString) {
            String[] keyElements = idString.split("-");
            Object id = ClassUtils.newInstance((Class)embType.getImplementationClass());
            List embAttrs = embType.getAttributes();
            if (keyElements.length != embAttrs.size()) {
                throw new UnsupportedOperationException("failed to parse " + idString + " for " + embType.getId());
            }
            for (int i = 0; i < keyElements.length; ++i) {
                MetaAttribute embAttr = (MetaAttribute)embAttrs.get(i);
                Object idElement = this.fromKeyString(embAttr.getType(), keyElements[i]);
                embAttr.setValue(id, idElement);
            }
            return id;
        }
    }

    class JpaOptimisticLockingValidator
    implements ResourceValidator {
        private MetaDataObject jpaMeta;

        public JpaOptimisticLockingValidator(MetaDataObject jpaMeta) {
            this.jpaMeta = jpaMeta;
        }

        public void validate(Object entity, Document requestDocument) {
            this.checkOptimisticLocking(entity, (Resource)requestDocument.getSingleData().get());
        }

        private void checkOptimisticLocking(Object entity, Resource resource) {
            JsonNode versionNode;
            MetaAttribute versionAttr = this.jpaMeta.getVersionAttribute();
            if (versionAttr != null && (versionNode = (JsonNode)resource.getAttributes().get(versionAttr.getName())) != null) {
                Object requestVersion = JpaResourceInformationProvider.this.context.getTypeParser().parse(versionNode.asText(), versionAttr.getType().getImplementationClass());
                Object currentVersion = versionAttr.getValue(entity);
                if (!currentVersion.equals(requestVersion)) {
                    throw new OptimisticLockException(resource.getId() + " changed from version " + requestVersion + " to " + currentVersion);
                }
            }
        }
    }
}

