/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.jpa.internal.query.AbstractQueryExecutorImpl;
import io.crnk.jpa.internal.query.ComputedAttributeRegistryImpl;
import io.crnk.jpa.internal.query.QueryBuilder;
import io.crnk.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.jpa.query.JpaQuery;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.provider.MetaPartition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.criteria.JoinType;

public abstract class AbstractJpaQueryImpl<T, B extends JpaQueryBackend<?, ?, ?, ?>>
implements JpaQuery<T> {
    protected final EntityManager em;
    protected final MetaDataObject meta;
    protected final Class<T> clazz;
    protected final Map<MetaAttributePath, JoinType> joinTypes = new HashMap<MetaAttributePath, JoinType>();
    protected JoinType defaultJoinType = JoinType.INNER;
    protected ArrayList<FilterSpec> filterSpecs = new ArrayList();
    protected ArrayList<SortSpec> sortSpecs = new ArrayList();
    protected ArrayList<IncludeFieldSpec> includedFields = new ArrayList();
    protected boolean autoDistinct = true;
    protected boolean autoGroupBy = false;
    protected boolean distinct = false;
    protected boolean ensureTotalOrder = true;
    protected MetaDataObject parentMeta;
    protected List<?> parentIds;
    protected MetaAttribute parentAttr;
    protected boolean parentIdSelection;
    private ComputedAttributeRegistryImpl computedAttrs;
    private Object privateData;

    protected AbstractJpaQueryImpl(MetaPartition metaPartition, EntityManager em, Class<T> clazz, ComputedAttributeRegistryImpl computedAttrs) {
        this.em = em;
        this.clazz = clazz;
        this.meta = (MetaDataObject)metaPartition.getMeta(clazz);
        this.computedAttrs = computedAttrs;
    }

    public AbstractJpaQueryImpl(MetaPartition metaPartition, EntityManager em, Class<?> entityClass, ComputedAttributeRegistryImpl virtualAttrs, String attrName, List<?> entityIds) {
        this.em = em;
        this.computedAttrs = virtualAttrs;
        this.parentMeta = (MetaDataObject)metaPartition.getMeta(entityClass);
        MetaAttribute attrMeta = this.parentMeta.getAttribute(attrName);
        this.meta = attrMeta.getType().isCollection() ? (MetaDataObject)attrMeta.getType().asCollection().getElementType() : (MetaDataObject)attrMeta.getType();
        this.clazz = this.meta.getImplementationClass();
        this.parentAttr = attrMeta;
        this.parentIds = entityIds;
    }

    @Override
    public Object getPrivateData() {
        return this.privateData;
    }

    @Override
    public void setPrivateData(Object privateData) {
        this.privateData = privateData;
    }

    @Override
    public void addParentIdSelection() {
        this.parentIdSelection = true;
    }

    @Override
    public void addSelection(List<String> path) {
        this.includedFields.add(new IncludeFieldSpec(path));
    }

    @Override
    public JpaQuery<T> setEnsureTotalOrder(boolean ensureTotalOrder) {
        this.ensureTotalOrder = ensureTotalOrder;
        return this;
    }

    @Override
    public JpaQuery<T> addFilter(FilterSpec filters) {
        this.filterSpecs.add(filters);
        return this;
    }

    @Override
    public JpaQuery<T> addSortBy(List<String> attributePath, Direction dir) {
        this.sortSpecs.add(new SortSpec(attributePath, dir));
        return this;
    }

    @Override
    public JpaQuery<T> addSortBy(SortSpec order) {
        this.sortSpecs.add(order);
        return this;
    }

    @Override
    public JpaQuery<T> setDefaultJoinType(JoinType joinType) {
        this.defaultJoinType = joinType;
        return this;
    }

    @Override
    public JpaQuery<T> setJoinType(List<String> path, JoinType joinType) {
        this.joinTypes.put(this.meta.resolvePath(path), joinType);
        return this;
    }

    @Override
    public JpaQuery<T> setAutoGroupBy(boolean autoGroupBy) {
        this.autoGroupBy = autoGroupBy;
        return this;
    }

    @Override
    public JpaQuery<T> setDistinct(boolean distinct) {
        this.autoDistinct = false;
        this.distinct = distinct;
        return this;
    }

    @Override
    public JpaQuery<T> addFilter(String attrPath, FilterOperator filterOperator, Object value) {
        return this.addFilter(Arrays.asList(attrPath.split("\\.")), filterOperator, value);
    }

    @Override
    public JpaQuery<T> addFilter(List<String> attrPath, FilterOperator filterOperator, Object value) {
        this.addFilter(new FilterSpec(attrPath, filterOperator, value));
        return this;
    }

    public List<SortSpec> getSortSpecs() {
        return this.sortSpecs;
    }

    public boolean getEnsureTotalOrder() {
        return this.ensureTotalOrder;
    }

    public List<IncludeFieldSpec> getIncludedFields() {
        return this.includedFields;
    }

    public JoinType getJoinType(MetaAttributePath path) {
        JoinType joinType = this.joinTypes.get(path);
        if (joinType == null) {
            joinType = this.defaultJoinType;
        }
        return joinType;
    }

    public ComputedAttributeRegistryImpl getComputedAttrs() {
        return this.computedAttrs;
    }

    public MetaDataObject getMeta() {
        return this.meta;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    public AbstractQueryExecutorImpl<T> buildExecutor() {
        B backend = this.newBackend();
        QueryBuilder executorFactory = new QueryBuilder(this, backend);
        Map<String, Integer> selectionBindings = executorFactory.applySelectionSpec();
        executorFactory.applyFilterSpec();
        executorFactory.applySortSpec();
        int numAutoSelections = executorFactory.applyDistinct();
        return this.newExecutor(backend, numAutoSelections, selectionBindings);
    }

    protected abstract AbstractQueryExecutorImpl<T> newExecutor(B var1, int var2, Map<String, Integer> var3);

    protected abstract B newBackend();

    public <T> List<T> getParentIds() {
        return this.parentIds;
    }

    public List<FilterSpec> getFilterSpecs() {
        return this.filterSpecs;
    }

    public MetaAttribute getParentAttr() {
        return this.parentAttr;
    }

    public MetaDataObject getParentMeta() {
        return this.parentMeta;
    }
}

