/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.jpa.internal.query.EntityGraphBuilder;
import io.crnk.jpa.query.JpaQueryExecutor;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public abstract class AbstractQueryExecutorImpl<T>
implements JpaQueryExecutor<T> {
    private static final String ENTITY_GRAPH_BUILDER_IMPL = "io.crnk.jpa.internal.query.EntityGraphBuilderImpl";
    protected int offset = 0;
    protected int limit = -1;
    protected boolean cached = false;
    protected EntityManager em;
    protected int numAutoSelections;
    protected Set<MetaAttributePath> fetchPaths = new HashSet<MetaAttributePath>();
    protected MetaDataObject meta;
    protected Map<String, Integer> selectionBindings;

    public AbstractQueryExecutorImpl(EntityManager em, MetaDataObject meta, int numAutoSelections, Map<String, Integer> selectionBindings) {
        this.em = em;
        this.meta = meta;
        this.numAutoSelections = numAutoSelections;
        this.selectionBindings = selectionBindings;
    }

    protected static List<Object[]> enforceDistinct(List<?> list) {
        HashSet<TupleElement> distinctSet = new HashSet<TupleElement>();
        ArrayList<Object[]> distinctResult = new ArrayList<Object[]>();
        for (Object obj : list) {
            Object[] values = (Object[])obj;
            TupleElement tuple = new TupleElement(values);
            if (distinctSet.contains(tuple)) continue;
            distinctSet.add(tuple);
            distinctResult.add(values);
        }
        return distinctResult;
    }

    @Override
    public JpaQueryExecutor<T> fetch(List<String> attrPath) {
        MetaAttributePath path = this.meta.resolvePath(attrPath);
        for (int i = 1; i <= path.length(); ++i) {
            this.fetchPaths.add(path.subPath(0, i));
        }
        return this;
    }

    @Override
    public JpaQueryExecutor<T> setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    @Override
    public JpaQueryExecutor<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public JpaQueryExecutor<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public JpaQueryExecutor<T> setWindow(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        return this;
    }

    @Override
    public List<T> getResultList() {
        List<T> resultList;
        List<T> list = this.executeQuery();
        if (this.isCompoundSelection()) {
            ArrayList<T> entityList = new ArrayList<T>();
            for (T obj : list) {
                Object[] values = (Object[])obj;
                entityList.add(values[0]);
            }
            resultList = entityList;
        } else {
            resultList = list;
        }
        return resultList;
    }

    protected abstract boolean isCompoundSelection();

    @Override
    public T getUniqueResult(boolean nullable) {
        List<T> list = this.getResultList();
        if (list.size() > 1) {
            throw new IllegalStateException("query does not return unique value, " + list.size() + " results returned");
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        if (nullable) {
            return null;
        }
        throw new IllegalStateException("no result found");
    }

    protected List<Object> truncateTuples(List<?> list, int numToRemove) {
        ArrayList<Object> truncatedList = new ArrayList<Object>();
        for (Object obj : list) {
            Object[] tuple = (Object[])obj;
            Object[] truncatedTuple = new Object[tuple.length - numToRemove];
            System.arraycopy(tuple, 0, truncatedTuple, 0, truncatedTuple.length);
            truncatedList.add(truncatedTuple);
        }
        return truncatedList;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.meta.getImplementationClass();
    }

    protected void applyFetchPaths(Query criteriaQuery) {
        if (!this.fetchPaths.isEmpty()) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class builderClass = ClassUtils.loadClass((ClassLoader)classLoader, (String)ENTITY_GRAPH_BUILDER_IMPL);
            EntityGraphBuilder builder = (EntityGraphBuilder)ClassUtils.newInstance((Class)builderClass);
            Class<T> entityClass = this.getEntityClass();
            builder.build(this.em, criteriaQuery, entityClass, this.fetchPaths);
        }
    }

    public abstract Query getTypedQuery();

    protected Query setupQuery(Query typedQuery) {
        if (!this.fetchPaths.isEmpty()) {
            this.applyFetchPaths(typedQuery);
        }
        if (this.cached) {
            typedQuery.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        }
        if (this.limit > 0) {
            typedQuery.setMaxResults(this.limit);
        }
        typedQuery.setFirstResult(this.offset);
        return typedQuery;
    }

    public List<T> executeQuery() {
        Query typedQuery = this.getTypedQuery();
        this.setupQuery(typedQuery);
        List<Object> resultList = typedQuery.getResultList();
        if (this.isCompoundSelection() && this.isDistinct() && this.hasManyRootsFetchesOrJoins()) {
            resultList = AbstractQueryExecutorImpl.enforceDistinct(resultList);
        }
        if (this.numAutoSelections > 0) {
            resultList = this.truncateTuples(resultList, this.numAutoSelections);
        }
        return resultList;
    }

    protected abstract boolean hasManyRootsFetchesOrJoins();

    protected abstract boolean isDistinct();

    static class TupleElement {
        private Object[] data;
        private int hashCode;

        TupleElement(Object[] data) {
            this.data = data;
            this.hashCode = Arrays.hashCode(data);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TupleElement)) {
                return false;
            }
            TupleElement tuple = (TupleElement)obj;
            return tuple.hashCode == this.hashCode && Arrays.equals(this.data, tuple.data);
        }
    }
}

