/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.jpa.internal.query.MetaComputedAttribute;
import io.crnk.jpa.query.ComputedAttributeRegistry;
import io.crnk.jpa.query.JpaQueryFactoryContext;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaPartition;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ComputedAttributeRegistryImpl
implements ComputedAttributeRegistry {
    private Map<String, Registration> map = new HashMap<String, Registration>();
    private JpaQueryFactoryContext context;

    public void init(JpaQueryFactoryContext context) {
        this.context = context;
    }

    public Object get(MetaComputedAttribute attr) {
        Class clazz = attr.getParent().getImplementationClass();
        Registration registration = this.map.get(this.key(clazz, attr.getName()));
        return registration != null ? registration.expressionFactory : null;
    }

    public MetaComputedAttribute get(MetaDataObject meta, String name) {
        Class clazz = meta.getImplementationClass();
        Registration registration = this.map.get(this.key(clazz, name));
        return registration != null ? registration.getAttribute() : null;
    }

    public void register(Class<?> targetClass, String name, Object expressionFactory, Type type) {
        Registration registration = new Registration();
        registration.targetClass = targetClass;
        registration.name = name;
        registration.type = type;
        registration.expressionFactory = expressionFactory;
        this.map.put(this.key(targetClass, name), registration);
    }

    private String key(Class<?> targetClass, String name) {
        return targetClass.getName() + "." + name;
    }

    @Override
    public Set<String> getForType(Class<?> entityType) {
        HashSet<String> set = new HashSet<String>();
        for (Registration reg : this.map.values()) {
            MetaComputedAttribute attr = reg.getAttribute();
            MetaDataObject parent = attr.getParent();
            Class parentImpl = parent.getImplementationClass();
            if (!parentImpl.isAssignableFrom(entityType)) continue;
            set.add(attr.getName());
        }
        return set;
    }

    private class Registration {
        private MetaComputedAttribute attr;
        private Object expressionFactory;
        private Class<?> targetClass;
        private Type type;
        private String name;

        private Registration() {
        }

        public synchronized MetaComputedAttribute getAttribute() {
            if (this.attr == null) {
                MetaPartition metaPartition = ComputedAttributeRegistryImpl.this.context.getMetaPartition();
                MetaDataObject targetMeta = metaPartition.getMeta(this.targetClass).asDataObject();
                MetaType attrType = metaPartition.getMeta(this.type).asType();
                this.attr = new MetaComputedAttribute();
                this.attr.setParent((MetaElement)targetMeta, false);
                this.attr.setName(this.name);
                this.attr.setType(attrType);
            }
            return this.attr;
        }
    }
}

