/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.jpa.internal.query.EntityGraphBuilder;
import io.crnk.meta.model.MetaAttributePath;
import java.util.Set;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Subgraph;

public class EntityGraphBuilderImpl
implements EntityGraphBuilder {
    @Override
    public <T> void build(EntityManager em, Query criteriaQuery, Class<T> entityClass, Set<MetaAttributePath> fetchPaths) {
        EntityGraph graph = em.createEntityGraph(entityClass);
        for (MetaAttributePath fetchPath : fetchPaths) {
            this.applyFetchPaths(graph, fetchPath);
        }
        criteriaQuery.setHint("javax.persistence.fetchgraph", (Object)graph);
    }

    private <T> Subgraph<Object> applyFetchPaths(EntityGraph<T> graph, MetaAttributePath fetchPath) {
        if (fetchPath.length() >= 2) {
            MetaAttributePath parentPath = fetchPath.subPath(0, fetchPath.length() - 1);
            Subgraph<Object> parentGraph = this.applyFetchPaths(graph, parentPath);
            return parentGraph.addSubgraph(fetchPath.toString());
        }
        return graph.addSubgraph(fetchPath.toString());
    }
}

