/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.jpa.internal.query.AnyUtils;
import io.crnk.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.jpa.query.AnyTypeObject;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributeFinder;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.JoinType;

public final class QueryFilterBuilder<P, F> {
    private static final int PARAM_LIMIT_FOR_ORACLE = 900;
    private MetaAttributeFinder attributeFinder;
    private JpaQueryBackend<F, ?, P, ?> backend;

    protected QueryFilterBuilder(JpaQueryBackend<F, ?, P, ?> backend, MetaAttributeFinder attributeFinder) {
        this.backend = backend;
        this.attributeFinder = attributeFinder;
    }

    public List<P> filterSpecListToPredicateArray(MetaDataObject rootMeta, F root, List<FilterSpec> rowFilters) {
        return this.filterSpecListToPredicateArray(rootMeta, root, rowFilters, null);
    }

    public List<P> filterSpecListToPredicateArray(MetaDataObject rootMeta, F root, List<FilterSpec> rowFilters, JoinType defaultPredicateJoinType) {
        ArrayList<P> predicateList = new ArrayList<P>();
        for (FilterSpec rowFilter : rowFilters) {
            predicateList.add(this.filterSpecListToPredicate(rootMeta, root, rowFilter, defaultPredicateJoinType));
        }
        return predicateList;
    }

    protected P filterSpecListToPredicate(MetaDataObject rootMeta, F root, FilterSpec fs, JoinType defaultPredicateJoinType) {
        if ((fs.getOperator() == FilterOperator.EQ || fs.getOperator() == FilterOperator.NEQ) && fs.getValue() instanceof Collection && ((Collection)fs.getValue()).size() > 900) {
            return this.filterLargeValueSets(fs, rootMeta, root, defaultPredicateJoinType);
        }
        if (fs.hasExpressions()) {
            return this.filterExpressions(fs, rootMeta, root, defaultPredicateJoinType);
        }
        return this.filterSimpleOperation(fs, rootMeta);
    }

    private P filterLargeValueSets(FilterSpec filterSpec, MetaDataObject rootMeta, F root, JoinType defaultPredicateJoinType) {
        ArrayList<FilterSpec> filterSpecs = new ArrayList<FilterSpec>();
        ArrayList list = new ArrayList((Collection)filterSpec.getValue());
        for (int i = 0; i < list.size(); i += 900) {
            int nextOffset = i + Math.min(list.size() - i, 900);
            List batchList = list.subList(i, nextOffset);
            filterSpecs.add(new FilterSpec(filterSpec.getAttributePath(), filterSpec.getOperator(), batchList));
        }
        FilterSpec orSpec = FilterSpec.or(filterSpecs);
        return this.filterSpecListToPredicate(rootMeta, root, orSpec, defaultPredicateJoinType);
    }

    private P filterSimpleOperation(FilterSpec fs, MetaDataObject rootMeta) {
        ArrayList value = fs.getValue();
        if (value instanceof Set) {
            Set set = (Set)((Object)value);
            value = new ArrayList(set);
        }
        MetaAttributePath path = rootMeta.resolvePath(fs.getAttributePath(), this.attributeFinder);
        path = this.enhanceAttributePath(path, value);
        return this.backend.buildPredicate(fs.getOperator(), path, value);
    }

    private P filterExpressions(FilterSpec fs, MetaDataObject rootMeta, F root, JoinType defaultPredicateJoinType) {
        if (fs.getOperator() == FilterOperator.NOT) {
            return this.backend.not(this.backend.and(this.filterSpecListToPredicateArray(rootMeta, root, fs.getExpression(), defaultPredicateJoinType)));
        }
        if (fs.getOperator() == FilterOperator.AND) {
            return this.backend.and(this.filterSpecListToPredicateArray(rootMeta, root, fs.getExpression(), defaultPredicateJoinType));
        }
        if (fs.getOperator() == FilterOperator.OR) {
            return this.backend.or(this.filterSpecListToPredicateArray(rootMeta, root, fs.getExpression(), defaultPredicateJoinType));
        }
        throw new IllegalArgumentException(fs.toString());
    }

    public MetaAttributePath enhanceAttributePath(MetaAttributePath attrPath, Object value) {
        boolean anyType;
        MetaAttribute attr = attrPath.getLast();
        MetaType valueType = attr.getType();
        if (valueType instanceof MetaMapType) {
            valueType = valueType.getElementType();
        }
        if (anyType = AnyTypeObject.class.isAssignableFrom(valueType.getImplementationClass())) {
            MetaAttribute anyAttr = AnyUtils.findAttribute((MetaDataObject)valueType, value);
            return attrPath.concat(new MetaAttribute[]{anyAttr});
        }
        return attrPath;
    }
}

