/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.jpa.internal.query.AbstractJpaQueryImpl;
import io.crnk.jpa.internal.query.QueryUtil;
import io.crnk.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.jpa.query.AnyTypeObject;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributeFinder;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaType;
import java.util.ArrayList;
import java.util.List;

public class QuerySortBuilder<T, E, O> {
    protected JpaQueryBackend<?, O, ?, E> backend;
    protected AbstractJpaQueryImpl<T, ?> query;
    private MetaAttributeFinder attributeFinder;

    public QuerySortBuilder(AbstractJpaQueryImpl<T, ?> query, JpaQueryBackend<?, O, ?, E> backend, MetaAttributeFinder attributeFinder) {
        this.backend = backend;
        this.query = query;
        this.attributeFinder = attributeFinder;
    }

    public void applySortSpec() {
        List<SortSpec> sortSpecs = this.query.getSortSpecs();
        if (!sortSpecs.isEmpty()) {
            this.backend.setOrder(this.sortSpecListToArray());
        }
        if (this.query.getEnsureTotalOrder() && !QueryUtil.hasTotalOrder(this.query.getMeta(), sortSpecs)) {
            List<O> totalOrderList = this.backend.getOrderList();
            MetaPrimaryKey primaryKey = this.query.getMeta().getPrimaryKey();
            if (primaryKey != null) {
                for (MetaAttribute primaryKeyElem : primaryKey.getElements()) {
                    E primaryKeyExpr = this.backend.getAttribute(new MetaAttributePath(new MetaAttribute[]{primaryKeyElem}));
                    O primaryKeyElemOrder = this.backend.newSort(primaryKeyExpr, Direction.ASC);
                    totalOrderList.add(primaryKeyElemOrder);
                }
            }
            this.backend.setOrder(totalOrderList);
        }
    }

    protected List<O> sortSpecListToArray() {
        ArrayList<O> orderList = new ArrayList<O>();
        for (SortSpec sortSpec : this.query.getSortSpecs()) {
            orderList.addAll(this.sortSpecToOrder(sortSpec));
        }
        return orderList;
    }

    private List<O> sortSpecToOrder(SortSpec sortSpec) {
        boolean anyType;
        ArrayList<O> orders = new ArrayList<O>();
        MetaAttributePath path = this.query.getMeta().resolvePath(sortSpec.getAttributePath(), this.attributeFinder);
        MetaAttribute attr = path.getLast();
        MetaType valueType = attr.getType();
        if (valueType instanceof MetaMapType) {
            valueType = valueType.getElementType();
        }
        if (anyType = AnyTypeObject.class.isAssignableFrom(valueType.getImplementationClass())) {
            MetaDataObject anyMeta = valueType.asDataObject();
            for (MetaAttribute anyAttr : anyMeta.getAttributes()) {
                if (anyAttr.isDerived()) continue;
                E expr = this.backend.getAttribute(path.concat(new MetaAttribute[]{anyAttr}));
                orders.add(this.backend.newSort(expr, sortSpec.getDirection()));
            }
        } else {
            E expr = this.backend.getAttribute(path);
            orders.add(this.backend.newSort(expr, sortSpec.getDirection()));
        }
        return orders;
    }
}

