/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query;

import io.crnk.core.queryspec.SortSpec;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaKey;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.SingularAttribute;

public class QueryUtil {
    private QueryUtil() {
    }

    public static boolean hasTotalOrder(MetaDataObject meta, List<SortSpec> sortSpecs) {
        boolean hasTotalOrder = QueryUtil.contains((MetaKey)meta.getPrimaryKey(), sortSpecs);
        if (hasTotalOrder) {
            return true;
        }
        for (MetaKey key : meta.getDeclaredKeys()) {
            if (!key.isUnique() || !QueryUtil.contains(key, sortSpecs)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(MetaKey key, List<SortSpec> entitySortSpecs) {
        for (MetaAttribute attr : key.getElements()) {
            boolean contains = false;
            for (SortSpec sortSpec : entitySortSpecs) {
                List sortAttrPath = sortSpec.getAttributePath();
                if (sortAttrPath.size() != 1 || !((String)sortAttrPath.get(0)).equals(attr.getName())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public static boolean hasManyRootsFetchesOrJoins(CriteriaQuery<?> criteriaQuery) {
        Set roots = criteriaQuery.getRoots();
        if (roots.size() != 1) {
            return false;
        }
        for (Root root : roots) {
            if (QueryUtil.containsMultiRelationFetch(root.getFetches())) {
                return true;
            }
            if (!QueryUtil.containsMultiRelationJoin(root.getJoins())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsMultiRelationFetch(Set<?> fetches) {
        for (Object fetchObj : fetches) {
            Fetch fetch = (Fetch)fetchObj;
            Attribute attr = fetch.getAttribute();
            if (attr.isAssociation() && attr.isCollection()) {
                return true;
            }
            if (!QueryUtil.containsMultiRelationFetch(fetch.getFetches())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsMultiRelationJoin(Set<?> fetches) {
        for (Object fetchObj : fetches) {
            Fetch fetch = (Fetch)fetchObj;
            Attribute attr = fetch.getAttribute();
            if (attr.isAssociation() && attr.isCollection()) {
                return true;
            }
            if (!QueryUtil.containsMultiRelationFetch(fetch.getFetches())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRelation(Object expr) {
        if (expr instanceof Join) {
            return true;
        }
        if (expr instanceof SingularAttribute) {
            SingularAttribute attr = (SingularAttribute)expr;
            return attr.isAssociation();
        }
        if (expr instanceof Path) {
            Path attrPath = (Path)expr;
            Bindable model = attrPath.getModel();
            Path parent = attrPath.getParentPath();
            return QueryUtil.containsRelation(parent) || QueryUtil.containsRelation(model);
        }
        return false;
    }
}

