/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query.backend.criteria;

import io.crnk.jpa.internal.query.AbstractQueryExecutorImpl;
import io.crnk.jpa.internal.query.QueryUtil;
import io.crnk.jpa.internal.query.backend.criteria.CriteriaTupleImpl;
import io.crnk.jpa.internal.query.backend.querydsl.ObjectArrayTupleImpl;
import io.crnk.jpa.query.criteria.JpaCriteriaQueryExecutor;
import io.crnk.meta.model.MetaDataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class JpaCriteriaQueryExecutorImpl<T>
extends AbstractQueryExecutorImpl<T>
implements JpaCriteriaQueryExecutor<T> {
    private CriteriaQuery<T> query;

    public JpaCriteriaQueryExecutorImpl(EntityManager em, MetaDataObject meta, CriteriaQuery<T> criteriaQuery, int numAutoSelections, Map<String, Integer> selectionBindings) {
        super(em, meta, numAutoSelections, selectionBindings);
        this.query = criteriaQuery;
    }

    public CriteriaQuery<T> getQuery() {
        return this.query;
    }

    public TypedQuery<T> getTypedQuery() {
        return (TypedQuery)this.setupQuery((Query)this.em.createQuery(this.query));
    }

    @Override
    protected boolean isCompoundSelection() {
        return this.query.getSelection().isCompoundSelection();
    }

    @Override
    protected boolean isDistinct() {
        return this.query.isDistinct();
    }

    @Override
    protected boolean hasManyRootsFetchesOrJoins() {
        return QueryUtil.hasManyRootsFetchesOrJoins(this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalRowCount() {
        long l;
        Selection selection = this.query.getSelection();
        List orderList = this.query.getOrderList();
        try {
            CriteriaBuilder builder = this.em.getCriteriaBuilder();
            Set roots = this.query.getRoots();
            if (roots.size() != 1) {
                throw new IllegalStateException("cannot compute totalRowCount in case of multiple query roots");
            }
            if (!this.query.getGroupList().isEmpty()) {
                throw new IllegalStateException("cannot compute totalRowCount for grouped queries");
            }
            Root root = (Root)roots.iterator().next();
            Expression countExpr = builder.count((Expression)root);
            this.query.multiselect(new Selection[]{countExpr});
            this.query.orderBy(new ArrayList());
            TypedQuery countQuery = this.em.createQuery(this.query);
            l = (Long)countQuery.getSingleResult();
        }
        catch (Throwable throwable) {
            this.query.multiselect(new Selection[]{selection});
            this.query.orderBy(orderList);
            throw throwable;
        }
        this.query.multiselect(new Selection[]{selection});
        this.query.orderBy(orderList);
        return l;
    }

    @Override
    public List<Tuple> getResultTuples() {
        List results = this.executeQuery();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (Object result : results) {
            if (result instanceof Object[]) {
                tuples.add(new CriteriaTupleImpl((Object[])result, this.selectionBindings));
                continue;
            }
            tuples.add(new ObjectArrayTupleImpl(result, this.selectionBindings));
        }
        return tuples;
    }
}

