/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query.backend.querydsl;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.QTuple;
import com.querydsl.jpa.impl.JPAQuery;
import io.crnk.jpa.internal.query.AbstractQueryExecutorImpl;
import io.crnk.jpa.internal.query.backend.querydsl.QuerydslObjectArrayTupleImpl;
import io.crnk.jpa.internal.query.backend.querydsl.QuerydslTupleImpl;
import io.crnk.jpa.internal.query.backend.querydsl.QuerydslUtils;
import io.crnk.jpa.query.querydsl.QuerydslExecutor;
import io.crnk.jpa.query.querydsl.QuerydslTuple;
import io.crnk.meta.model.MetaDataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class QuerydslExecutorImpl<T>
extends AbstractQueryExecutorImpl<T>
implements QuerydslExecutor<T> {
    private JPAQuery<T> query;

    public QuerydslExecutorImpl(EntityManager em, MetaDataObject meta, JPAQuery<T> query, int numAutoSelections, Map<String, Integer> selectionBindings) {
        super(em, meta, numAutoSelections, selectionBindings);
        this.query = query;
    }

    @Override
    public JPAQuery<T> getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(JPAQuery<T> query) {
        this.query = query;
    }

    public TypedQuery<T> getTypedQuery() {
        return (TypedQuery)this.setupQuery(this.query.createQuery());
    }

    @Override
    protected boolean isCompoundSelection() {
        return this.query.getMetadata().getProjection() instanceof QTuple;
    }

    @Override
    protected boolean isDistinct() {
        return this.query.getMetadata().isDistinct();
    }

    @Override
    protected boolean hasManyRootsFetchesOrJoins() {
        return QuerydslUtils.hasManyRootsFetchesOrJoins(this.query);
    }

    @Override
    public long getTotalRowCount() {
        return this.query.fetchCount();
    }

    @Override
    public List<QuerydslTuple> getResultTuples() {
        List results = this.executeQuery();
        ArrayList<QuerydslTuple> tuples = new ArrayList<QuerydslTuple>();
        for (Object result : results) {
            if (result instanceof Tuple) {
                tuples.add(new QuerydslTupleImpl((Tuple)result, this.selectionBindings));
                continue;
            }
            tuples.add(new QuerydslObjectArrayTupleImpl(result, this.selectionBindings));
        }
        return tuples;
    }
}

