/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query.backend.querydsl;

import com.google.common.collect.ImmutableList;
import com.querydsl.core.support.FetchableSubQueryBase;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OperationImpl;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.QTuple;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CollectionExpressionBase;
import com.querydsl.core.types.dsl.CollectionPathBase;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.MapExpressionBase;
import com.querydsl.core.types.dsl.MapPath;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAQueryBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.jpa.internal.query.ComputedAttributeRegistryImpl;
import io.crnk.jpa.internal.query.JoinRegistry;
import io.crnk.jpa.internal.query.MetaComputedAttribute;
import io.crnk.jpa.internal.query.QueryUtil;
import io.crnk.jpa.internal.query.backend.JpaQueryBackend;
import io.crnk.jpa.internal.query.backend.querydsl.QuerydslQueryImpl;
import io.crnk.jpa.internal.query.backend.querydsl.QuerydslUtils;
import io.crnk.jpa.query.querydsl.QuerydslExpressionFactory;
import io.crnk.jpa.query.querydsl.QuerydslTranslationContext;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaAttributePath;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaPrimaryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.criteria.JoinType;

public class QuerydslQueryBackend<T>
implements QuerydslTranslationContext<T>,
JpaQueryBackend<Expression<?>, OrderSpecifier<?>, Predicate, Expression<?>> {
    private JoinRegistry<Expression<?>, Expression<?>> joinHelper;
    private Path<T> root;
    private EntityPath<?> parentFrom;
    private QuerydslQueryImpl<T> queryImpl;
    private JPAQueryBase querydslQuery;
    private List<OrderSpecifier<?>> orderList = new ArrayList();

    public QuerydslQueryBackend(QuerydslQueryImpl<T> queryImpl, Class<T> clazz, MetaDataObject parentMeta, MetaAttribute parentAttr, boolean addParentSelection) {
        this.queryImpl = queryImpl;
        JPAQueryFactory queryFactory = queryImpl.getQueryFactory();
        if (parentMeta != null) {
            this.parentFrom = QuerydslUtils.getEntityPath(parentMeta.getImplementationClass());
            this.root = QuerydslUtils.getEntityPath(clazz);
            Path joinPath = (Path)QuerydslUtils.get(this.parentFrom, parentAttr.getName());
            this.joinHelper = new JoinRegistry(this, queryImpl);
            this.joinHelper.putJoin(new MetaAttributePath(new MetaAttribute[0]), (Expression<?>)this.root);
            if (addParentSelection) {
                Expression<Object> parentIdExpr = this.getParentIdExpression(parentMeta, parentAttr);
                this.querydslQuery = queryFactory.select(new Expression[]{parentIdExpr, this.root});
            } else {
                this.querydslQuery = queryFactory.select(this.root);
            }
            this.querydslQuery = this.querydslQuery.from(this.parentFrom);
            this.querydslQuery = joinPath instanceof CollectionExpression ? this.querydslQuery.join((CollectionExpression)joinPath, this.root) : this.querydslQuery.join((EntityPath)joinPath, this.root);
        } else {
            this.root = QuerydslUtils.getEntityPath(clazz);
            this.joinHelper = new JoinRegistry(this, queryImpl);
            this.joinHelper.putJoin(new MetaAttributePath(new MetaAttribute[0]), (Expression<?>)this.root);
            this.querydslQuery = queryFactory.select(this.root);
            this.querydslQuery = this.querydslQuery.from((EntityPath)this.root);
        }
    }

    private Expression<Object> getParentIdExpression(MetaDataObject parentMeta, MetaAttribute parentAttr) {
        MetaPrimaryKey primaryKey = parentMeta.getPrimaryKey();
        PreconditionUtil.assertNotNull((String)("no primary key specified for parentAttribute " + parentAttr.getId()), (Object)parentMeta);
        List elements = primaryKey.getElements();
        PreconditionUtil.assertEquals((String)"composite primary keys not supported yet", (Object)1, (Object)elements.size());
        MetaAttribute primaryKeyAttr = (MetaAttribute)elements.get(0);
        return QuerydslUtils.get(this.parentFrom, primaryKeyAttr.getName());
    }

    @Override
    public JPAQuery<T> getQuery() {
        JPAQueryBase finalQuery = this.querydslQuery;
        for (OrderSpecifier<?> order : this.orderList) {
            finalQuery = (JPAQueryBase)finalQuery.orderBy(order);
        }
        return (JPAQuery)finalQuery;
    }

    @Override
    public Expression<?> getAttribute(MetaAttributePath attrPath) {
        return this.joinHelper.getEntityAttribute(attrPath);
    }

    @Override
    public void addPredicate(Predicate predicate) {
        this.querydslQuery = (JPAQueryBase)this.querydslQuery.where(predicate);
    }

    @Override
    public Path<T> getRoot() {
        return this.root;
    }

    @Override
    public void setOrder(List<OrderSpecifier<?>> list) {
        this.orderList = list;
    }

    @Override
    public List<OrderSpecifier<?>> getOrderList() {
        return this.orderList;
    }

    @Override
    public OrderSpecifier<?> newSort(Expression<?> expr, Direction dir) {
        if (dir == Direction.ASC) {
            return new OrderSpecifier(Order.ASC, expr);
        }
        return new OrderSpecifier(Order.DESC, expr);
    }

    @Override
    public void distinct() {
        this.querydslQuery = (JPAQueryBase)this.querydslQuery.distinct();
    }

    @Override
    public void addParentPredicate(MetaAttribute primaryKeyAttr) {
        List parentIds = this.queryImpl.getParentIds();
        SimpleExpression parentIdPath = (SimpleExpression)QuerydslUtils.get(this.parentFrom, primaryKeyAttr.getName());
        this.addPredicate((Predicate)parentIdPath.in(parentIds));
    }

    @Override
    public boolean hasManyRootsFetchesOrJoins() {
        return QuerydslUtils.hasManyRootsFetchesOrJoins((JPAQuery)this.querydslQuery);
    }

    @Override
    public void addSelection(Expression<?> expression, String name) {
        Expression selection = this.querydslQuery.getMetadata().getProjection();
        ArrayList<Object> newSelection = new ArrayList<Object>();
        if (selection != null) {
            if (selection instanceof QTuple) {
                newSelection.addAll(((QTuple)selection).getArgs());
            } else {
                newSelection.add(selection);
            }
        }
        newSelection.add(expression);
        this.querydslQuery = (JPAQuery)this.querydslQuery.select(newSelection.toArray(new Expression[newSelection.size()]));
    }

    @Override
    public Expression<?> getExpression(OrderSpecifier<?> order) {
        return order.getTarget();
    }

    @Override
    public boolean containsRelation(Expression<?> expression) {
        return QueryUtil.containsRelation(expression);
    }

    @Override
    public Predicate buildPredicate(FilterOperator operator, MetaAttributePath attrPath, Object value) {
        Expression<?> attr = this.getAttribute(attrPath);
        return this.buildPredicate(operator, attr, value);
    }

    public Predicate buildPredicate(FilterOperator operator, Expression<?> expressionObj, Object value) {
        Expression<?> expression = expressionObj;
        expression = this.handleConversions(expression, operator);
        return this.handle(expression, operator, value);
    }

    private Predicate handle(Expression expression, FilterOperator operator, Object value) {
        if (operator == FilterOperator.EQ || operator == FilterOperator.NEQ) {
            return this.handleEquals(expression, operator, value);
        }
        if (operator == FilterOperator.LIKE) {
            return ((StringExpression)expression).lower().like(value.toString().toLowerCase());
        }
        if (operator == FilterOperator.GT) {
            if (expression instanceof FetchableSubQueryBase) {
                return ((FetchableSubQueryBase)expression).gt(value);
            }
            if (expression instanceof NumberExpression) {
                return ((NumberExpression)expression).gt((Number)value);
            }
            return ((ComparableExpression)expression).gt((Comparable)value);
        }
        if (operator == FilterOperator.LT) {
            if (expression instanceof FetchableSubQueryBase) {
                return ((FetchableSubQueryBase)expression).lt(value);
            }
            if (expression instanceof NumberExpression) {
                return ((NumberExpression)expression).lt((Number)value);
            }
            return ((ComparableExpression)expression).lt((Comparable)value);
        }
        if (operator == FilterOperator.GE) {
            if (expression instanceof FetchableSubQueryBase) {
                return ((FetchableSubQueryBase)expression).goe(value);
            }
            if (expression instanceof NumberExpression) {
                return ((NumberExpression)expression).goe((Number)value);
            }
            return ((ComparableExpression)expression).goe((Comparable)value);
        }
        if (operator == FilterOperator.LE) {
            if (expression instanceof FetchableSubQueryBase) {
                return ((FetchableSubQueryBase)expression).loe(value);
            }
            if (expression instanceof NumberExpression) {
                return ((NumberExpression)expression).loe((Number)value);
            }
            return ((ComparableExpression)expression).loe((Comparable)value);
        }
        throw new IllegalStateException("unexpected operator " + operator);
    }

    private Predicate handleEquals(Expression<?> leftExpression, FilterOperator operator, Object value) {
        SimpleExpression expression = leftExpression;
        if (Collection.class.isAssignableFrom(expression.getType())) {
            CollectionPathBase collectionExpr = (CollectionPathBase)expression;
            expression = collectionExpr.any();
        }
        if (value instanceof List) {
            BooleanExpression p = ((SimpleExpression)expression).in((Collection)((List)value));
            return this.negateIfNeeded((Predicate)p, operator);
        }
        if (expression instanceof MapExpressionBase) {
            MapExpressionBase mapExpression = (MapExpressionBase)expression;
            BooleanExpression p = mapExpression.containsValue(value);
            return this.negateIfNeeded((Predicate)p, operator);
        }
        if (value == null) {
            return this.negateIfNeeded((Predicate)expression.isNull(), operator);
        }
        return this.negateIfNeeded((Predicate)expression.eq(value), operator);
    }

    private Expression<?> handleConversions(Expression<?> expression, FilterOperator operator) {
        if (expression.getType() != String.class && operator == FilterOperator.LIKE) {
            return Expressions.stringOperation((Operator)Ops.STRING_CAST, (Expression[])new Expression[]{expression});
        }
        return expression;
    }

    @Override
    public Predicate and(List<Predicate> predicates) {
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        Predicate result = predicates.get(0);
        for (int i = 1; i < predicates.size(); ++i) {
            result = new BooleanPredicateOperation(Ops.AND, ImmutableList.of((Object)result, (Object)predicates.get(i)));
        }
        return result;
    }

    @Override
    public Predicate not(Predicate predicate) {
        return predicate.not();
    }

    @Override
    public Predicate or(List<Predicate> predicates) {
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        Predicate result = predicates.get(0);
        for (int i = 1; i < predicates.size(); ++i) {
            result = new BooleanPredicateOperation(Ops.OR, ImmutableList.of((Object)result, (Object)predicates.get(i)));
        }
        return result;
    }

    private Predicate negateIfNeeded(Predicate p, FilterOperator fc) {
        if (fc.equals((Object)FilterOperator.NEQ)) {
            return p.not();
        }
        return p;
    }

    @Override
    public Expression<?> joinMapValue(Expression<?> currentCriteriaPath, MetaAttribute pathElement, Object key) {
        MapPath mapPath = (MapPath)QuerydslUtils.get(currentCriteriaPath, pathElement.getName());
        return mapPath.get(key);
    }

    @Override
    public Class<?> getJavaElementType(Expression<?> expression) {
        if (expression instanceof CollectionExpressionBase) {
            return ((CollectionExpressionBase)expression).getElementType();
        }
        return expression.getType();
    }

    @Override
    public Expression<?> getAttribute(Expression<?> expression, MetaAttribute pathElement) {
        if (pathElement instanceof MetaComputedAttribute) {
            ComputedAttributeRegistryImpl virtualAttrs = this.queryImpl.getComputedAttrs();
            QuerydslExpressionFactory expressionFactory = (QuerydslExpressionFactory)virtualAttrs.get((MetaComputedAttribute)pathElement);
            return expressionFactory.getExpression(expression, this.getQuery());
        }
        return QuerydslUtils.get(expression, pathElement.getName());
    }

    @Override
    public Expression<?> joinSubType(Expression<?> expression, Class<?> entityClass) {
        BeanPath beanPath = (BeanPath)expression;
        Class<?> queryClass = QuerydslUtils.getQueryClass(entityClass);
        return beanPath.as(queryClass);
    }

    @Override
    public Expression<?> doJoin(MetaAttribute targetAttr, JoinType joinType, Expression<?> parent) {
        if (targetAttr instanceof MetaComputedAttribute) {
            MetaComputedAttribute computedAttr = (MetaComputedAttribute)targetAttr;
            QuerydslExpressionFactory expressionFactory = (QuerydslExpressionFactory)this.queryImpl.getComputedAttrs().get(computedAttr);
            return expressionFactory.getExpression(parent, this.getQuery());
        }
        Expression expression = QuerydslUtils.get(parent, targetAttr.getName());
        this.querydslQuery.getMetadata().addJoin(QuerydslUtils.convertJoinType(joinType), expression);
        return expression;
    }

    @Override
    public JPAQueryFactory getQueryFactory() {
        return this.queryImpl.getQueryFactory();
    }

    @Override
    public EntityPath getParentRoot() {
        return this.parentFrom;
    }

    @Override
    public <E> EntityPath<E> getJoin(MetaAttributePath path) {
        return (EntityPath)this.joinHelper.getOrCreateJoin(path);
    }

    @Override
    public <U> QuerydslTranslationContext<U> castFor(Class<U> type) {
        return this;
    }

    public final class BooleanPredicateOperation
    extends OperationImpl<Boolean>
    implements Predicate {
        private static final long serialVersionUID = -5371430939203772072L;
        @Nullable
        private volatile transient Predicate not;

        protected BooleanPredicateOperation(Ops ops, ImmutableList<Expression<?>> list) {
            super(Boolean.class, (Operator)ops, list);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("list cannot be empty");
            }
        }

        public Predicate not() {
            if (this.not == null) {
                this.not = ExpressionUtils.predicate((Operator)Ops.NOT, (Expression[])new Expression[]{this});
            }
            return this.not;
        }
    }
}

