/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query.backend.querydsl;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import io.crnk.jpa.query.querydsl.QuerydslTuple;
import java.util.Arrays;
import java.util.Map;

public class QuerydslTupleImpl
implements QuerydslTuple {
    private Tuple tuple;
    private Map<String, Integer> selectionBindings;
    private int numEntriesToIgnore;

    public QuerydslTupleImpl(Tuple tuple, Map<String, Integer> selectionBindings) {
        this.tuple = tuple;
        this.selectionBindings = selectionBindings;
    }

    @Override
    public <T> T get(int index, Class<T> type) {
        return (T)this.tuple.get(index + this.numEntriesToIgnore, type);
    }

    public <T> T get(Expression<T> expr) {
        return (T)this.tuple.get(expr);
    }

    public int size() {
        return this.tuple.size() - this.numEntriesToIgnore;
    }

    public Object[] toArray() {
        Object[] data = this.tuple.toArray();
        if (this.numEntriesToIgnore > 0) {
            return Arrays.copyOfRange(data, this.numEntriesToIgnore, data.length);
        }
        return data;
    }

    @Override
    public <T> T get(String name, Class<T> clazz) {
        Integer index = this.selectionBindings.get(name);
        if (index == null) {
            throw new IllegalArgumentException("selection " + name + " not found");
        }
        return this.get(index, clazz);
    }

    @Override
    public void reduce(int numEntriesToIgnore) {
        this.numEntriesToIgnore = numEntriesToIgnore;
    }
}

