/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.internal.query.backend.querydsl;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.jpa.impl.JPAQuery;
import java.lang.reflect.Field;
import java.util.List;

class QuerydslUtils {
    private QuerydslUtils() {
    }

    public static <T> EntityPath<T> getEntityPath(Class<T> entityClass) {
        Class<?> queryClass = QuerydslUtils.getQueryClass(entityClass);
        try {
            String fieldName = QuerydslUtils.firstToLower(entityClass.getSimpleName());
            Field field = queryClass.getField(fieldName);
            return (EntityPath)field.get(entityClass);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("failed to access query class " + queryClass.getName(), e);
        }
    }

    public static <T> Expression<T> get(Expression<?> path, String name) {
        try {
            Class<?> clazz = path.getClass();
            Field field = clazz.getField(name);
            return (Expression)field.get(path);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("failed get field " + path + "." + name, e);
        }
    }

    public static JoinType convertJoinType(javax.persistence.criteria.JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return JoinType.JOIN;
            }
            case LEFT: {
                return JoinType.LEFTJOIN;
            }
            case RIGHT: {
                return JoinType.RIGHTJOIN;
            }
        }
        throw new IllegalStateException(joinType.toString() + " unknown");
    }

    private static String firstToLower(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean hasManyRootsFetchesOrJoins(JPAQuery<?> query) {
        List joins = query.getMetadata().getJoins();
        for (JoinExpression join : joins) {
            if (!(join.getTarget() instanceof CollectionExpression)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getQueryClass(Class<?> entityClass) {
        String queryClassName = entityClass.getPackage().getName() + ".Q" + entityClass.getSimpleName();
        try {
            return entityClass.getClassLoader().loadClass(queryClassName);
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            throw new IllegalStateException("unable to find query class " + queryClassName, e);
        }
    }
}

