/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.meta.internal;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.jpa.meta.MetaEmbeddable;
import io.crnk.jpa.meta.MetaEmbeddableAttribute;
import io.crnk.jpa.meta.internal.AbstractJpaDataObjectFactory;
import io.crnk.jpa.query.AnyTypeObject;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import java.lang.reflect.Type;
import javax.persistence.Embeddable;

public class EmbeddableMetaFactory
extends AbstractJpaDataObjectFactory<MetaEmbeddable> {
    private static final Object VALUE_ANYTYPE_ATTR_NAME = "value";

    public boolean accept(Type type) {
        return ClassUtils.getRawType((Type)type).getAnnotation(Embeddable.class) != null;
    }

    public MetaEmbeddable create(Type type) {
        Class rawClazz = ClassUtils.getRawType((Type)type);
        Class superClazz = rawClazz.getSuperclass();
        MetaElement superMeta = null;
        if (superClazz != Object.class) {
            superMeta = this.context.allocate(superClazz);
        }
        MetaEmbeddable meta = new MetaEmbeddable();
        meta.setElementType((MetaType)meta);
        meta.setName(rawClazz.getSimpleName());
        meta.setImplementationType(type);
        meta.setSuperType((MetaDataObject)superMeta);
        if (superMeta != null) {
            ((MetaDataObject)superMeta).addSubType((MetaDataObject)meta);
        }
        this.createAttributes(meta);
        return meta;
    }

    protected MetaAttribute createAttribute(MetaEmbeddable metaDataObject, String name) {
        MetaEmbeddableAttribute attr = new MetaEmbeddableAttribute();
        attr.setParent((MetaElement)metaDataObject, true);
        attr.setName(name);
        attr.setFilterable(true);
        attr.setSortable(true);
        if (AnyTypeObject.class.isAssignableFrom(metaDataObject.getImplementationClass()) && name.equals(VALUE_ANYTYPE_ATTR_NAME)) {
            attr.setDerived(true);
        }
        return attr;
    }
}

