/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.meta.internal;

import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.jpa.meta.MetaJpaDataObject;
import io.crnk.jpa.meta.internal.JpaMetaPartition;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaFilterBase;
import io.crnk.meta.provider.MetaProviderContext;
import java.lang.reflect.Type;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class JpaMetaFilter
extends MetaFilterBase {
    private final MetaProviderContext context;
    private final JpaMetaPartition partition;

    public JpaMetaFilter(JpaMetaPartition partition, MetaProviderContext context) {
        this.context = context;
        this.partition = partition;
    }

    public void onInitialized(MetaElement element) {
        String mappedBy;
        MetaAttribute attr;
        if (element.getParent() instanceof MetaJpaDataObject && element instanceof MetaAttribute) {
            attr = (MetaAttribute)element;
            MetaDataObject parent = attr.getParent();
            Type implementationType = PropertyUtils.getPropertyType((Class)parent.getImplementationClass(), (String)attr.getName());
            MetaType metaType = (MetaType)this.partition.allocateMetaElement(implementationType).get();
            attr.setType(metaType);
        }
        if (element.getParent() instanceof MetaJpaDataObject && element instanceof MetaAttribute && ((MetaAttribute)element).getOppositeAttribute() == null && (mappedBy = this.getMappedBy(attr = (MetaAttribute)element)) != null) {
            MetaType attrType = attr.getType();
            MetaDataObject oppositeType = attrType.getElementType().asDataObject();
            if (!mappedBy.contains(".")) {
                MetaAttribute oppositeAttr = oppositeType.getAttribute(mappedBy);
                attr.setOppositeAttribute(oppositeAttr);
            }
        }
    }

    private String getMappedBy(MetaAttribute attr) {
        ManyToMany manyManyAnnotation = (ManyToMany)attr.getAnnotation(ManyToMany.class);
        OneToMany oneManyAnnotation = (OneToMany)attr.getAnnotation(OneToMany.class);
        OneToOne oneOneAnnotation = (OneToOne)attr.getAnnotation(OneToOne.class);
        String mappedBy = null;
        if (manyManyAnnotation != null) {
            mappedBy = manyManyAnnotation.mappedBy();
        }
        if (oneManyAnnotation != null) {
            mappedBy = oneManyAnnotation.mappedBy();
        }
        if (oneOneAnnotation != null) {
            mappedBy = oneOneAnnotation.mappedBy();
        }
        if (mappedBy != null && mappedBy.length() == 0) {
            mappedBy = null;
        }
        return mappedBy;
    }
}

