/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.jpa.meta.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;

public class JpaMetaUtils {
    public static boolean isJpaType(Class<?> type) {
        return type.getAnnotation(Embeddable.class) != null || type.getAnnotation(Entity.class) != null || type.getAnnotation(MappedSuperclass.class) != null;
    }

    public static Class<?> getElementType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (paramType.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)paramType.getRawType())) {
                return JpaMetaUtils.getElementType(paramType.getActualTypeArguments()[1]);
            }
            if (paramType.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)paramType.getRawType())) {
                return JpaMetaUtils.getElementType(paramType.getActualTypeArguments()[0]);
            }
        }
        throw new IllegalArgumentException(type.toString());
    }
}

