/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.engine.information.repository.RepositoryAction;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldNameTransformer;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationBuilder;
import io.crnk.core.engine.information.resource.ResourceInformationBuilderContext;
import io.crnk.core.engine.internal.information.resource.AnnotationResourceInformationBuilder;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.ResourceListBase;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.utils.Optional;
import io.crnk.legacy.registry.DefaultResourceInformationBuilderContext;
import io.crnk.meta.information.MetaAwareInformation;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.resource.MetaJsonObject;
import io.crnk.meta.model.resource.MetaResource;
import io.crnk.meta.model.resource.MetaResourceAction;
import io.crnk.meta.model.resource.MetaResourceBase;
import io.crnk.meta.model.resource.MetaResourceField;
import io.crnk.meta.model.resource.MetaResourceRepository;
import io.crnk.meta.provider.MetaProviderBase;
import io.crnk.meta.provider.MetaProviderContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class ResourceMetaProviderImpl
extends MetaProviderBase {
    private boolean useResourceRegistry;

    public ResourceMetaProviderImpl(boolean useResourceRegistry) {
        this.useResourceRegistry = useResourceRegistry;
    }

    @Override
    public Set<Class<? extends MetaElement>> getMetaTypes() {
        return new HashSet<Class<? extends MetaElement>>(Arrays.asList(MetaResource.class, MetaJsonObject.class, MetaResourceBase.class, MetaResourceField.class));
    }

    @Override
    public boolean accept(Type type, Class<? extends MetaElement> metaClass) {
        Class clazz;
        ResourceRegistry resourceRegistry;
        if (metaClass != MetaResource.class && metaClass != MetaElement.class && metaClass != MetaResourceBase.class && metaClass != MetaJsonObject.class) {
            return false;
        }
        if (this.useResourceRegistry && (resourceRegistry = this.context.getModuleContext().getResourceRegistry()) != null && metaClass == MetaResource.class && resourceRegistry.getEntryForClass(clazz = ClassUtils.getRawType((Type)type)) != null) {
            return true;
        }
        return metaClass == MetaResourceBase.class || ClassUtils.getRawType((Type)type).getAnnotation(JsonApiResource.class) != null;
    }

    @Override
    public MetaElement createElement(Type type) {
        String resourceType;
        boolean allowNonResourceBaseClass = type != MetaResource.class;
        ResourceInformation information = this.getResourceInformation(ClassUtils.getRawType((Type)type), allowNonResourceBaseClass);
        Class resourceClass = information.getResourceClass();
        Class superClass = resourceClass.getSuperclass();
        MetaDataObject superMeta = null;
        if (superClass != Object.class) {
            superMeta = this.context.getLookup().getMeta(superClass, MetaResourceBase.class);
        }
        MetaResourceBase resource = (resourceType = information.getResourceType()) != null ? new MetaResource() : new MetaResourceBase();
        resource.setElementType(resource);
        resource.setImplementationType(resourceClass);
        resource.setSuperType(superMeta);
        if (superMeta != null) {
            superMeta.addSubType(resource);
        }
        resource.setName(resourceClass.getSimpleName());
        if (resourceType != null) {
            ((MetaResource)resource).setResourceType(resourceType);
        }
        List fields = information.getFields();
        for (ResourceField field : fields) {
            this.addAttribute(resource, field);
        }
        return resource;
    }

    @Override
    public void discoverElements() {
        if (this.useResourceRegistry) {
            ResourceRegistry resourceRegistry = this.context.getModuleContext().getResourceRegistry();
            for (RegistryEntry entry : resourceRegistry.getResources()) {
                ResourceInformation information = entry.getResourceInformation();
                MetaResource metaResource = this.context.getLookup().getMeta(information.getResourceClass(), MetaResource.class);
                ResourceRepositoryInformation repositoryInformation = entry.getRepositoryInformation();
                ResourceRepositoryAdapter resourceRepository = entry.getResourceRepository(null);
                if (resourceRepository == null) continue;
                MetaResourceRepository repository = this.discoverRepository(repositoryInformation, metaResource, resourceRepository, this.context);
                this.context.add(repository);
            }
        }
    }

    private MetaResourceRepository discoverRepository(ResourceRepositoryInformation repositoryInformation, MetaResource metaResource, ResourceRepositoryAdapter<?, Serializable> resourceRepository, MetaProviderContext context) {
        MetaResourceRepository meta = new MetaResourceRepository();
        meta.setResourceType(metaResource);
        meta.setName(metaResource.getName() + "Repository");
        meta.setId(metaResource.getId() + "Repository");
        for (RepositoryAction action : repositoryInformation.getActions().values()) {
            MetaResourceAction metaAction = new MetaResourceAction();
            metaAction.setName(action.getName());
            metaAction.setActionType(MetaResourceAction.MetaRepositoryActionType.valueOf(action.getActionType().toString()));
            metaAction.setParent(meta, true);
        }
        Object repository = resourceRepository.getResourceRepository();
        if (repository instanceof ResourceRepositoryV2) {
            this.setListInformationTypes(repository, context, meta);
        }
        return meta;
    }

    private void setListInformationTypes(final Object repository, final MetaProviderContext context, final MetaResourceRepository meta) {
        ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Method findMethod = repository.getClass().getMethod("findAll", QuerySpec.class);
                Class<?> listType = findMethod.getReturnType();
                if (ResourceListBase.class.equals(listType.getSuperclass()) && listType.getGenericSuperclass() instanceof ParameterizedType) {
                    ParameterizedType genericSuperclass = (ParameterizedType)listType.getGenericSuperclass();
                    Class metaType = ClassUtils.getRawType((Type)genericSuperclass.getActualTypeArguments()[1]);
                    Class linksType = ClassUtils.getRawType((Type)genericSuperclass.getActualTypeArguments()[2]);
                    if (!metaType.equals(MetaInformation.class)) {
                        MetaDataObject listMetaType = context.getLookup().getMeta(metaType, MetaJsonObject.class);
                        meta.setListMetaType(listMetaType);
                    }
                    if (!linksType.equals(LinksInformation.class)) {
                        MetaDataObject listLinksType = context.getLookup().getMeta(linksType, MetaJsonObject.class);
                        meta.setListLinksType(listLinksType);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void onInitialized(MetaElement element) {
        if (element instanceof MetaResourceBase) {
            MetaResourceBase metaResource = (MetaResourceBase)element;
            ResourceInformation information = this.getResourceInformation(metaResource.getImplementationClass(), true);
            PreconditionUtil.assertNotNull((String)information.getResourceType(), (Object)metaResource);
            for (ResourceField field : information.getRelationshipFields()) {
                if (field.getOppositeName() == null) continue;
                Class oppositeType = ClassUtils.getRawType((Type)field.getElementType());
                MetaResource oppositeMeta = this.context.getLookup().getMeta(oppositeType, MetaResource.class);
                MetaAttribute attr = metaResource.getAttribute(field.getUnderlyingName());
                MetaAttribute oppositeAttr = oppositeMeta.getAttribute(field.getOppositeName());
                PreconditionUtil.assertNotNull((String)(attr.getId() + " opposite not found"), (Object)oppositeAttr);
                attr.setOppositeAttribute(oppositeAttr);
            }
            ResourceField idField = information.getIdField();
            if (idField != null) {
                MetaAttribute idAttr = metaResource.getAttribute(idField.getUnderlyingName());
                idAttr.setPrimaryKeyAttribute(true);
                if (metaResource.getSuperType() == null || metaResource.getSuperType().getPrimaryKey() == null) {
                    MetaPrimaryKey primaryKey = new MetaPrimaryKey();
                    primaryKey.setName(metaResource.getName() + "$primaryKey");
                    primaryKey.setName(metaResource.getId() + "$primaryKey");
                    primaryKey.setElements(Arrays.asList(idAttr));
                    primaryKey.setUnique(true);
                    primaryKey.setParent(metaResource, true);
                    metaResource.setPrimaryKey(primaryKey);
                    this.context.add(primaryKey);
                }
            }
            if (information instanceof MetaAwareInformation && ((MetaAwareInformation)information).getProjectedMetaElement().isPresent()) {
                MetaDataObject projectedMeta = (MetaDataObject)((MetaAwareInformation)information).getProjectedMetaElement().get();
                if (metaResource.getPrimaryKey() != null && projectedMeta.getPrimaryKey() != null) {
                    metaResource.getPrimaryKey().setGenerated(projectedMeta.getPrimaryKey().isGenerated());
                }
            }
        }
        if (element instanceof MetaAttribute && element.getParent() instanceof MetaResourceBase) {
            ResourceField field;
            MetaAttribute attr = (MetaAttribute)element;
            MetaResourceBase parent = (MetaResourceBase)attr.getParent();
            ResourceInformation information = this.getResourceInformation(parent.getImplementationClass(), true);
            field = information.findFieldByUnderlyingName(attr.getName());
            PreconditionUtil.assertNotNull((String)attr.getName(), (Object)field);
            Type implementationType = field.getGenericType();
            MetaJsonObject metaType = this.context.getLookup().getMeta(implementationType, MetaJsonObject.class);
            attr.setType(metaType.asType());
        }
    }

    private ResourceInformation getResourceInformation(Class<?> resourceClass, boolean allowNonResourceBaseClass) {
        ResourceRegistry resourceRegistry;
        RegistryEntry entry;
        if (this.useResourceRegistry && (entry = (resourceRegistry = this.context.getModuleContext().getResourceRegistry()).getEntryForClass(resourceClass)) != null) {
            PreconditionUtil.assertNotNull((String)resourceClass.getName(), (Object)entry);
            return entry.getResourceInformation();
        }
        ResourceInformationBuilder infoBuilder = this.context.getModuleContext().getResourceInformationBuilder();
        if (infoBuilder.accept(resourceClass)) {
            return infoBuilder.build(resourceClass);
        }
        if (allowNonResourceBaseClass) {
            AnnotationResourceInformationBuilder fallbackBuilder = new AnnotationResourceInformationBuilder(new ResourceFieldNameTransformer());
            fallbackBuilder.init((ResourceInformationBuilderContext)new DefaultResourceInformationBuilderContext(infoBuilder, new TypeParser()));
            return fallbackBuilder.build(resourceClass, true);
        }
        throw new IllegalStateException("failed to get information for " + resourceClass.getName());
    }

    private void addAttribute(MetaResourceBase resource, ResourceField field) {
        MetaAwareInformation metaField;
        Optional projectedElement;
        if (resource.getSuperType() != null && resource.getSuperType().hasAttribute(field.getUnderlyingName())) {
            return;
        }
        MetaResourceField attr = new MetaResourceField();
        attr.setParent(resource, true);
        attr.setName(field.getUnderlyingName());
        attr.setAssociation(field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP);
        attr.setMeta(field.getResourceFieldType() == ResourceFieldType.META_INFORMATION);
        attr.setLinks(field.getResourceFieldType() == ResourceFieldType.LINKS_INFORMATION);
        attr.setDerived(false);
        attr.setLazy(field.isLazy());
        attr.setSortable(field.getAccess().isSortable());
        attr.setFilterable(field.getAccess().isFilterable());
        attr.setInsertable(field.getAccess().isPostable());
        attr.setUpdatable(field.getAccess().isPatchable());
        boolean isPrimitive = ClassUtils.isPrimitiveType((Class)field.getType());
        boolean isId = field.getResourceFieldType() == ResourceFieldType.ID;
        attr.setNullable(!isPrimitive && !isId);
        PreconditionUtil.assertFalse((String)attr.getName(), (!attr.isAssociation() && MetaElement.class.isAssignableFrom(field.getElementType()) ? 1 : 0) != 0);
        if (field instanceof MetaAwareInformation && (projectedElement = (metaField = (MetaAwareInformation)field).getProjectedMetaElement()).isPresent()) {
            MetaAttribute projectedAttr = (MetaAttribute)projectedElement.get();
            attr.setLob(projectedAttr.isLob());
            attr.setVersion(projectedAttr.isVersion());
            attr.setNullable(projectedAttr.isNullable());
            attr.setCascaded(projectedAttr.isCascaded());
        }
    }
}

