/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.module.Module;
import io.crnk.meta.model.MetaArrayType;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaEnumType;
import io.crnk.meta.model.MetaListType;
import io.crnk.meta.model.MetaLiteral;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimitiveType;
import io.crnk.meta.model.MetaSetType;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaProvider;
import io.crnk.meta.provider.MetaProviderContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaLookup.class);
    private static final String BASE_ID_PREFIX = "base.";
    private MultivaluedMap<Type, MetaElement> typeElementsMap = new MultivaluedMap();
    private ConcurrentHashMap<String, MetaElement> idElementMap = new ConcurrentHashMap();
    private Set<Class<?>> primitiveTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    private List<MetaProvider> providers = new CopyOnWriteArrayList<MetaProvider>();
    private LinkedList<MetaElement> initializationQueue = new LinkedList();
    private boolean adding = false;
    private MetaProviderContext context;
    private Map<String, String> packageIdMapping = new HashMap<String, String>();
    private boolean discovered;
    private Module.ModuleContext moduleContext;

    public MetaLookup() {
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Number.class);
        this.registerPrimitiveType(Boolean.class);
        this.registerPrimitiveType(Integer.class);
        this.registerPrimitiveType(Short.class);
        this.registerPrimitiveType(Byte.class);
        this.registerPrimitiveType(Long.class);
        this.registerPrimitiveType(Float.class);
        this.registerPrimitiveType(Double.class);
        this.registerPrimitiveType(UUID.class);
        this.registerPrimitiveType(Date.class);
        this.registerPrimitiveType(Timestamp.class);
        this.registerPrimitiveType(JsonNode.class);
        this.registerPrimitiveType(ObjectNode.class);
        this.registerPrimitiveType(ArrayNode.class);
        this.registerPrimitiveType(byte[].class);
        this.registerPrimitiveType(boolean[].class);
        this.registerPrimitiveType(int[].class);
        this.registerPrimitiveType(short[].class);
        this.registerPrimitiveType(long[].class);
        this.registerPrimitiveType(double[].class);
        this.registerPrimitiveType(float[].class);
        this.context = new MetaProviderContext(){

            @Override
            public void add(MetaElement element) {
                MetaLookup.this.add(element);
            }

            @Override
            public MetaLookup getLookup() {
                return MetaLookup.this;
            }

            @Override
            public Module.ModuleContext getModuleContext() {
                return MetaLookup.this.moduleContext;
            }
        };
        this.putIdMapping("io.crnk.jpa.meta", "io.crnk.jpa");
        this.putIdMapping("io.crnk.meta.model", "io.crnk.meta");
        this.putIdMapping("io.crnk.meta.model.resource", "io.crnk.meta.resource");
    }

    private static String firstToLower(String name) {
        if (name.equals(JsonNode.class.getSimpleName())) {
            return "json";
        }
        if (name.equals(ObjectNode.class.getSimpleName())) {
            return "json.object";
        }
        if (name.equals(ArrayNode.class.getSimpleName())) {
            return "json.array";
        }
        if (name.equals("UUID")) {
            return "uuid";
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public void setModuleContext(Module.ModuleContext moduleContext) {
        this.moduleContext = moduleContext;
    }

    public Map<String, MetaElement> getMetaById() {
        return Collections.unmodifiableMap(this.idElementMap);
    }

    public void registerPrimitiveType(Class<?> clazz) {
        this.primitiveTypes.add(clazz);
    }

    public void addProvider(MetaProvider provider) {
        if (!this.providers.contains(provider)) {
            provider.init(this.context);
            this.providers.add(provider);
            for (MetaProvider dependency : provider.getDependencies()) {
                this.addProvider(dependency);
            }
        }
    }

    public MetaElement getMeta(Type type) {
        return this.getMeta(type, MetaElement.class);
    }

    public <T extends MetaElement> T getMeta(Type type, Class<T> metaClass) {
        return (T)this.getMetaInternal(type, metaClass, false);
    }

    public <T extends MetaElement> T getMeta(Type type, Class<T> metaClass, boolean nullable) {
        return (T)this.getMetaInternal(type, metaClass, nullable);
    }

    public MetaArrayType getArrayMeta(Type type, Class<? extends MetaElement> elementMetaClass) {
        return (MetaArrayType)this.getMetaInternal(type, elementMetaClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaElement getMetaInternal(Type type, Class<? extends MetaElement> elementMetaClass, boolean nullable) {
        PreconditionUtil.assertNotNull((String)"type must not be null", (Object)type);
        this.checkInitialized();
        MetaElement existingElement = this.getUniqueElementByType(type, elementMetaClass);
        if (existingElement == null) {
            MetaLookup metaLookup = this;
            synchronized (metaLookup) {
                existingElement = this.getUniqueElementByType(type, elementMetaClass);
                if (existingElement == null) {
                    MetaElement allocatedMeta;
                    boolean wasInitializing = this.adding;
                    if (!wasInitializing) {
                        this.adding = true;
                    }
                    if ((allocatedMeta = this.allocateMeta(type, elementMetaClass, nullable)) != null) {
                        this.add(allocatedMeta);
                    }
                    if (!wasInitializing) {
                        this.initialize();
                    }
                    return allocatedMeta;
                }
            }
        }
        return existingElement;
    }

    private MetaElement getUniqueElementByType(Type type, Class<? extends MetaElement> elementMetaClass) {
        if (!this.typeElementsMap.containsKey((Object)type)) {
            return null;
        }
        List elements = this.typeElementsMap.getList((Object)type);
        MetaElement result = null;
        for (MetaElement element : elements) {
            MetaElement meta = element;
            if (meta instanceof MetaType) {
                meta = ((MetaType)meta).getElementType();
            }
            if (!elementMetaClass.isInstance(meta)) continue;
            if (result != null) {
                throw new IllegalStateException("multiple elements found of type " + elementMetaClass + ": " + result + " vs " + element);
            }
            result = element;
        }
        return result;
    }

    private MetaElement allocateMeta(Type type, Class<? extends MetaElement> metaClass, boolean nullable) {
        MetaElement meta;
        LOGGER.debug("allocate {}", (Object)type);
        if (type instanceof Class && (meta = this.allocateMetaFromClass(type, metaClass)) != null) {
            return meta;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return this.allocateMetaFromParamerizedType(paramType, metaClass);
        }
        meta = this.allocateMetaFromFactory(type, metaClass);
        if (meta != null) {
            return meta;
        }
        if (nullable) {
            return null;
        }
        throw new UnsupportedOperationException("unknown type " + type);
    }

    private MetaElement allocateMetaFromClass(Type type, Class<? extends MetaElement> metaClass) {
        Class<?> elementClass;
        MetaType elementType;
        Class<?> clazz = (Class<?>)type;
        if (clazz.isEnum() && metaClass.isAssignableFrom(MetaEnumType.class)) {
            MetaEnumType enumType = new MetaEnumType();
            enumType.setElementType(enumType);
            enumType.setImplementationType(type);
            enumType.setName(clazz.getSimpleName());
            for (Object literalObj : clazz.getEnumConstants()) {
                MetaLiteral literal = new MetaLiteral();
                literal.setName(literalObj.toString());
                literal.setParent(enumType, true);
            }
            return enumType;
        }
        if (this.isPrimitiveType(clazz = this.mapPrimitiveType(clazz)) && metaClass.isAssignableFrom(MetaPrimitiveType.class)) {
            String id = BASE_ID_PREFIX + MetaLookup.firstToLower(clazz.getSimpleName());
            MetaPrimitiveType primitiveType = (MetaPrimitiveType)this.idElementMap.get(id);
            if (primitiveType == null) {
                primitiveType = new MetaPrimitiveType();
                primitiveType.setElementType(primitiveType);
                primitiveType.setImplementationType(clazz);
                primitiveType.setName(MetaLookup.firstToLower(clazz.getSimpleName()));
                primitiveType.setId(id);
            }
            return primitiveType;
        }
        if (clazz.isArray() && (elementType = (MetaType)this.getMeta(elementClass = ((Class)type).getComponentType(), metaClass, true)) != null) {
            MetaArrayType arrayType = new MetaArrayType();
            arrayType.setName(elementType.getName() + "$Array");
            arrayType.setId(elementType.getId() + "$Array");
            arrayType.setImplementationType(type);
            arrayType.setElementType(elementType);
            return arrayType;
        }
        return null;
    }

    private Class<?> mapPrimitiveType(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    private <T extends MetaElement> T allocateMetaFromFactory(Type type, Class<? extends MetaElement> metaClass) {
        for (MetaProvider factory : this.providers) {
            if (!factory.accept(type, metaClass)) continue;
            return (T)factory.createElement(type);
        }
        return null;
    }

    private MetaElement allocateMetaFromParamerizedType(ParameterizedType paramType, Class<? extends MetaElement> elementMetaClass) {
        if (paramType.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)paramType.getRawType())) {
            PreconditionUtil.assertEquals((String)"expected 2 type arguments", (Object)2, (Object)paramType.getActualTypeArguments().length);
            MetaType keyType = (MetaType)this.getMeta(paramType.getActualTypeArguments()[0]);
            MetaType valueType = (MetaType)this.getMeta(paramType.getActualTypeArguments()[1], elementMetaClass, true);
            if (keyType != null && valueType != null) {
                MetaMapType mapMeta = new MetaMapType();
                boolean primitiveKey = keyType instanceof MetaPrimitiveType;
                boolean primitiveValue = valueType instanceof MetaPrimitiveType;
                if (primitiveKey || !primitiveValue) {
                    mapMeta.setName(valueType.getName() + "$MappedBy$" + keyType.getName());
                    mapMeta.setId(valueType.getId() + "$MappedBy$" + keyType.getName());
                } else {
                    mapMeta.setName(keyType.getName() + "$Map$" + valueType.getName());
                    mapMeta.setId(keyType.getId() + "$Map$" + valueType.getName());
                }
                mapMeta.setImplementationType(paramType);
                mapMeta.setKeyType(keyType);
                mapMeta.setElementType(valueType);
                return mapMeta;
            }
        } else if (paramType.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)paramType.getRawType())) {
            return this.allocateMetaFromCollectionType(paramType, elementMetaClass);
        }
        return null;
    }

    public boolean exists(Type type, Class<MetaElement> metaElementClass) {
        return this.allocateMeta(type, metaElementClass, true) != null;
    }

    private MetaElement allocateMetaFromCollectionType(ParameterizedType paramType, Class<? extends MetaElement> elementMetaClass) {
        PreconditionUtil.assertEquals((String)"expected single type argument", (Object)1, (Object)paramType.getActualTypeArguments().length);
        MetaType elementType = (MetaType)this.getMeta(paramType.getActualTypeArguments()[0], elementMetaClass, true);
        if (elementType == null) {
            return null;
        }
        boolean isSet = Set.class.isAssignableFrom((Class)paramType.getRawType());
        boolean isList = List.class.isAssignableFrom((Class)paramType.getRawType());
        if (isSet) {
            MetaSetType metaSet = new MetaSetType();
            metaSet.setId(elementType.getId() + "$Set");
            metaSet.setName(elementType.getName() + "$Set");
            metaSet.setImplementationType(paramType);
            metaSet.setElementType(elementType);
            return metaSet;
        }
        if (isList) {
            PreconditionUtil.assertTrue((String)"expected a list type", (boolean)isList);
            MetaListType metaList = new MetaListType();
            metaList.setId(elementType.getId() + "$List");
            metaList.setName(elementType.getName() + "$List");
            metaList.setImplementationType(paramType);
            metaList.setElementType(elementType);
            return metaList;
        }
        return null;
    }

    public boolean isPrimitiveType(Class<?> clazz) {
        if ((clazz = this.mapPrimitiveType(clazz)) == Object.class) {
            return true;
        }
        if (clazz.getPackage() != null && clazz.getPackage().getName().equals("java.time")) {
            return true;
        }
        if (clazz.isPrimitive() || this.primitiveTypes.contains(clazz)) {
            return true;
        }
        for (Class<?> primitiveType : this.primitiveTypes) {
            if (!primitiveType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected void add(MetaElement element) {
        MetaType typeElement;
        PreconditionUtil.assertNotNull((String)"no name provided", (Object)element.getName());
        if (element instanceof MetaType) {
            typeElement = element.asType();
            Class<?> implClass = typeElement.getImplementationClass();
            if (!element.hasId()) {
                element.setId(this.computeIdPrefixFromPackage(implClass, element) + element.getName());
            }
        }
        if (!element.hasId() && element.getParent() != null) {
            element.setId(element.getParent().getId() + "." + element.getName());
        }
        if (this.idElementMap.get(element.getId()) != element) {
            LOGGER.debug("add {} of type {}", (Object)element.getId(), (Object)element.getClass().getSimpleName());
            this.initializationQueue.add(element);
            if (element instanceof MetaType) {
                typeElement = element.asType();
                if (this.typeElementsMap.containsKey((Object)typeElement.getImplementationType())) {
                    List existingElements = this.typeElementsMap.getList((Object)typeElement.getImplementationType());
                    for (MetaElement existingElement : existingElements) {
                        if (!existingElement.getId().equals(element.getId())) continue;
                        throw new IllegalStateException(element.getId() + " already available: " + existingElement + " vs " + element);
                    }
                }
                this.typeElementsMap.add((Object)typeElement.getImplementationType(), (Object)element);
            }
            MetaElement currentElement = this.idElementMap.get(element.getId());
            PreconditionUtil.assertNull((String)element.getId(), (Object)currentElement);
            this.idElementMap.put(element.getId(), element);
            for (MetaElement child : element.getChildren()) {
                this.add(child);
            }
        }
    }

    private String computeIdPrefixFromPackage(Class<?> implClass, MetaElement element) {
        Package implPackage = implClass.getPackage();
        if (implPackage == null && implClass.isArray()) {
            implPackage = implClass.getComponentType().getPackage();
        }
        if (implPackage == null) {
            throw new IllegalStateException(implClass.getName() + " does not belong to a package");
        }
        String packageName = implPackage.getName();
        StringBuilder idInfix = new StringBuilder(".");
        while (true) {
            String idMappingKey1 = this.toIdMappingKey(packageName, element.getClass());
            String idMappingKey2 = this.toIdMappingKey(packageName, null);
            String idPrefix = this.packageIdMapping.get(idMappingKey1);
            if (idPrefix == null) {
                idPrefix = this.packageIdMapping.get(idMappingKey2);
            }
            if (idPrefix != null) {
                return idPrefix + idInfix;
            }
            int sep = packageName.lastIndexOf(46);
            if (sep == -1) break;
            idInfix.append(packageName.substring(sep + 1));
            idInfix.append(".");
            packageName = packageName.substring(0, sep);
        }
        return implPackage.getName() + ".";
    }

    private void checkInitialized() {
        if (!this.discovered && !this.adding) {
            this.initialize();
        }
    }

    public void initialize() {
        LOGGER.debug("adding");
        this.adding = true;
        try {
            if (!this.discovered) {
                for (MetaProvider provider : this.providers) {
                    provider.discoverElements();
                }
                this.discovered = true;
            }
            while (!this.initializationQueue.isEmpty()) {
                MetaElement element = this.initializationQueue.pollFirst();
                if (element.getParent() != null) continue;
                this.initialize(element);
            }
        }
        finally {
            LOGGER.debug("added");
            this.adding = false;
        }
    }

    private void initialize(MetaElement element) {
        LOGGER.debug("adding {}", (Object)element.getId());
        for (MetaProvider initializer : this.providers) {
            this.packageIdMapping.putAll(initializer.getIdMappings());
        }
        for (MetaProvider initializer : this.providers) {
            initializer.onInitializing(element);
        }
        for (MetaElement child : element.getChildren()) {
            this.initialize(child);
        }
        for (MetaProvider initializer : this.providers) {
            initializer.onInitialized(element);
        }
        LOGGER.debug("added {}", (Object)element.getId());
    }

    public List<MetaProvider> getProviders() {
        return this.providers;
    }

    public void putIdMapping(String packageName, String idPrefix) {
        this.packageIdMapping.put(packageName, idPrefix);
    }

    public void putIdMapping(String packageName, Class<? extends MetaElement> type, String idPrefix) {
        this.packageIdMapping.put(this.toIdMappingKey(packageName, type), idPrefix);
    }

    private String toIdMappingKey(String packageName, Class<? extends MetaElement> type) {
        if (type != null) {
            return packageName + "#" + type.getName();
        }
        return packageName;
    }
}

