/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.model.MetaElement;
import java.util.Collection;

public class MetaRelationshipRepository
implements RelationshipRepositoryV2<MetaElement, String, MetaElement, String> {
    private MetaLookup lookup;
    private Class<? extends MetaElement> sourceResourceClass;
    private Class<? extends MetaElement> targetResourceClass;

    public MetaRelationshipRepository(MetaLookup lookup, Class<? extends MetaElement> sourceClass, Class<? extends MetaElement> targetClass) {
        this.lookup = lookup;
        this.sourceResourceClass = sourceClass;
        this.targetResourceClass = targetClass;
    }

    public MetaElement findOneTarget(String sourceId, String fieldName, QuerySpec querySpec) {
        MetaElement source = this.getSource(sourceId);
        Object value = PropertyUtils.getProperty((Object)source, (String)fieldName);
        return (MetaElement)value;
    }

    public ResourceList<MetaElement> findManyTargets(String sourceId, String fieldName, QuerySpec querySpec) {
        MetaElement source = this.getSource(sourceId);
        Object value = PropertyUtils.getProperty((Object)source, (String)fieldName);
        return querySpec.apply((Iterable)((Collection)value));
    }

    private MetaElement getSource(String sourceId) {
        MetaElement source = this.lookup.getMetaById().get(sourceId);
        if (source == null) {
            throw new ResourceNotFoundException(sourceId);
        }
        return source;
    }

    public Class<MetaElement> getSourceResourceClass() {
        return this.sourceResourceClass;
    }

    public Class<MetaElement> getTargetResourceClass() {
        return this.targetResourceClass;
    }

    public void setRelation(MetaElement source, String targetId, String fieldName) {
        throw this.newReadOnlyException();
    }

    public void setRelations(MetaElement source, Iterable<String> targetIds, String fieldName) {
        throw this.newReadOnlyException();
    }

    public void addRelations(MetaElement source, Iterable<String> targetIds, String fieldName) {
        throw this.newReadOnlyException();
    }

    public void removeRelations(MetaElement source, Iterable<String> targetIds, String fieldName) {
        throw this.newReadOnlyException();
    }

    private UnsupportedOperationException newReadOnlyException() {
        return new UnsupportedOperationException("read-only");
    }
}

