/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.model.MetaElement;
import java.util.ArrayList;
import java.util.Collection;

public class MetaResourceRepositoryImpl<T>
extends ResourceRepositoryBase<T, String> {
    private MetaLookup lookup;

    public MetaResourceRepositoryImpl(MetaLookup lookup, Class<T> resourceClass) {
        super(resourceClass);
        this.lookup = lookup;
    }

    public T findOne(String id, QuerySpec querySpec) {
        MetaElement metaElement = this.lookup.getMetaById().get(id);
        Class resourceClass = this.getResourceClass();
        if (metaElement != null && resourceClass.isInstance(metaElement)) {
            return (T)metaElement;
        }
        throw new ResourceNotFoundException(id);
    }

    public ResourceList<T> findAll(QuerySpec querySpec) {
        Collection<T> values = this.filterByType(this.lookup.getMetaById().values());
        return querySpec.apply(values);
    }

    private Collection<T> filterByType(Collection<MetaElement> values) {
        ArrayList<MetaElement> results = new ArrayList<MetaElement>();
        Class resourceClass = this.getResourceClass();
        for (MetaElement element : values) {
            if (!resourceClass.isInstance(element)) continue;
            results.add(element);
        }
        return results;
    }
}

