/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.provider.MetaProvider;
import java.util.ArrayList;
import java.util.List;

public class MetaModuleConfig {
    private List<IdMapping> idMappings = new ArrayList<IdMapping>();
    private List<MetaProvider> providers = new ArrayList<MetaProvider>();
    private boolean initialized = false;

    public void addIdMapping(String packageName, String idPrefix) {
        this.checkNotInitialized();
        this.idMappings.add(new IdMapping(packageName, null, idPrefix));
    }

    public void addIdMapping(String packageName, Class<? extends MetaElement> type, String idPrefix) {
        this.checkNotInitialized();
        this.idMappings.add(new IdMapping(packageName, type, idPrefix));
    }

    public void addMetaProvider(MetaProvider provider) {
        this.checkNotInitialized();
        this.providers.add(provider);
    }

    protected void apply(MetaLookup metaLookup) {
        for (IdMapping mapping : this.idMappings) {
            if (mapping.type != null) {
                metaLookup.putIdMapping(mapping.packageName, mapping.type, mapping.idPrefix);
                continue;
            }
            metaLookup.putIdMapping(mapping.packageName, mapping.idPrefix);
        }
        for (MetaProvider provider : this.providers) {
            metaLookup.addProvider(provider);
        }
    }

    private void checkNotInitialized() {
        PreconditionUtil.assertFalse((String)"configuration is already applied and cannot be changed anymore", (boolean)this.initialized);
    }

    protected List<MetaProvider> getProviders() {
        return this.providers;
    }

    protected List<IdMapping> getIdMappings() {
        return this.idMappings;
    }

    protected static class IdMapping {
        private final String packageName;
        private final Class<? extends MetaElement> type;
        private final String idPrefix;

        public IdMapping(String packageName, Class<? extends MetaElement> type, String idPrefix) {
            this.packageName = packageName;
            this.type = type;
            this.idPrefix = idPrefix;
        }
    }
}

