/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.utils.Supplier;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.internal.MetaUtils;
import io.crnk.meta.model.MetaElement;
import java.util.ArrayList;
import java.util.Collection;

public class MetaResourceRepositoryImpl<T>
extends ResourceRepositoryBase<T, String> {
    private final Supplier<MetaLookup> lookupSupplier;

    public MetaResourceRepositoryImpl(Supplier<MetaLookup> lookupSupplier, Class<T> resourceClass) {
        super(resourceClass);
        this.lookupSupplier = lookupSupplier;
    }

    public T findOne(String id, QuerySpec querySpec) {
        MetaElement wrappedElement;
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        MetaElement metaElement = lookup.getMetaById().get(id);
        Class resourceClass = this.getResourceClass();
        if (metaElement != null && resourceClass.isInstance(metaElement) && (wrappedElement = MetaUtils.adjustForRequest(lookup, metaElement)) != null) {
            return (T)metaElement;
        }
        throw new ResourceNotFoundException(id);
    }

    public ResourceList<T> findAll(QuerySpec querySpec) {
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        Collection<T> values = this.filterByType(lookup.getMetaById().values());
        return querySpec.apply(values);
    }

    private Collection<T> filterByType(Collection<MetaElement> values) {
        ArrayList<MetaElement> results = new ArrayList<MetaElement>();
        Class resourceClass = this.getResourceClass();
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        for (MetaElement element : values) {
            MetaElement wrappedElement;
            if (!resourceClass.isInstance(element) || (wrappedElement = MetaUtils.adjustForRequest(lookup, element)) == null) continue;
            results.add(wrappedElement);
        }
        return results;
    }
}

