/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.meta.internal.MetaDataObjectProvider;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.resource.MetaJsonObject;
import io.crnk.meta.provider.MetaProvider;
import java.lang.reflect.Type;
import java.util.Collection;

public class JsonObjectMetaProvider
extends MetaDataObjectProvider {
    @Override
    public boolean accept(Type type, Class<? extends MetaElement> metaClass) {
        Class rawType = ClassUtils.getRawType((Type)type);
        boolean hasResourceAnnotation = rawType.getAnnotation(JsonApiResource.class) != null;
        boolean collection = Collection.class.isAssignableFrom(rawType) || rawType.isArray();
        boolean primitive = this.context.getLookup().isPrimitiveType(rawType);
        boolean isEnum = Enum.class.isAssignableFrom(rawType);
        if (!(!(type instanceof Class) || isEnum || primitive || collection || metaClass != MetaJsonObject.class || hasResourceAnnotation)) {
            for (MetaProvider provider : this.context.getLookup().getProviders()) {
                if (provider == this || !provider.accept(type, metaClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected MetaDataObject newDataObject() {
        return new MetaJsonObject();
    }

    @Override
    protected Class<? extends MetaElement> getMetaClass() {
        return MetaJsonObject.class;
    }
}

