/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.JsonApiToMany;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaType;
import java.util.List;

@JsonApiResource(type="meta/key")
public class MetaKey
extends MetaElement {
    public static final String ID_ELEMENT_SEPARATOR = "-";
    @JsonApiToMany
    private List<MetaAttribute> elements;
    private boolean unique;

    private static String toEmbeddableKeyString(MetaDataObject embType, Object id) {
        StringBuilder builder = new StringBuilder();
        List<? extends MetaAttribute> embAttrs = embType.getAttributes();
        for (int i = 0; i < embAttrs.size(); ++i) {
            MetaAttribute embAttr = embAttrs.get(i);
            Object idElement = embAttr.getValue(id);
            if (i > 0) {
                builder.append(ID_ELEMENT_SEPARATOR);
            }
            builder.append(idElement);
        }
        return builder.toString();
    }

    public List<MetaAttribute> getElements() {
        return this.elements;
    }

    public void setElements(List<MetaAttribute> elements) {
        this.elements = elements;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @JsonIgnore
    public MetaAttribute getUniqueElement() {
        if (this.elements.size() != 1) {
            throw new IllegalStateException(this.getName() + " must contain a single primary key attribute");
        }
        return this.elements.get(0);
    }

    public String toKeyString(Object id) {
        if (id == null) {
            return null;
        }
        PreconditionUtil.assertEquals((String)"compound primary key not supported", (Object)1, (Object)this.elements.size());
        MetaAttribute keyAttr = this.elements.get(0);
        MetaType keyType = keyAttr.getType();
        if (keyType instanceof MetaDataObject) {
            MetaDataObject embType = (MetaDataObject)keyType;
            return MetaKey.toEmbeddableKeyString(embType, id);
        }
        return id.toString();
    }
}

