/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.utils.Optional;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaPrimitiveType;
import io.crnk.meta.provider.MetaPartitionBase;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class BaseMetaPartition
extends MetaPartitionBase {
    private static final String BASE_ID_PREFIX = "base.";
    private Set<Class<?>> primitiveTypes = Collections.newSetFromMap(new ConcurrentHashMap());

    public BaseMetaPartition() {
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Number.class);
        this.registerPrimitiveType(Boolean.class);
        this.registerPrimitiveType(Integer.class);
        this.registerPrimitiveType(Short.class);
        this.registerPrimitiveType(Byte.class);
        this.registerPrimitiveType(Long.class);
        this.registerPrimitiveType(Float.class);
        this.registerPrimitiveType(Double.class);
        this.registerPrimitiveType(UUID.class);
        this.registerPrimitiveType(Date.class);
        this.registerPrimitiveType(Timestamp.class);
        this.registerPrimitiveType(JsonNode.class);
        this.registerPrimitiveType(ObjectNode.class);
        this.registerPrimitiveType(ArrayNode.class);
        this.registerPrimitiveType(byte[].class);
        this.registerPrimitiveType(boolean[].class);
        this.registerPrimitiveType(int[].class);
        this.registerPrimitiveType(short[].class);
        this.registerPrimitiveType(long[].class);
        this.registerPrimitiveType(double[].class);
        this.registerPrimitiveType(float[].class);
    }

    @Override
    public MetaElement getMeta(Type type) {
        if (type instanceof Class) {
            return super.getMeta(this.mapPrimitiveType((Class)type));
        }
        return super.getMeta(type);
    }

    @Override
    protected Optional<MetaElement> addElement(Type type, MetaElement element) {
        if (type instanceof Class) {
            Class<?> objectType = this.mapPrimitiveType((Class)type);
            return super.addElement(objectType, element);
        }
        return super.addElement(type, element);
    }

    @Override
    protected Optional<MetaElement> doAllocateMetaElement(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (this.isPrimitiveType(clazz = this.mapPrimitiveType(clazz))) {
                String id = BASE_ID_PREFIX + BaseMetaPartition.firstToLower(clazz.getSimpleName());
                Optional<MetaElement> optPrimitiveType = this.context.getMetaElement(id);
                if (!optPrimitiveType.isPresent()) {
                    MetaPrimitiveType primitiveType = new MetaPrimitiveType();
                    primitiveType.setElementType(primitiveType);
                    primitiveType.setImplementationType(clazz);
                    primitiveType.setName(BaseMetaPartition.firstToLower(clazz.getSimpleName()));
                    primitiveType.setId(id);
                    return this.addElement(type, primitiveType);
                }
                return optPrimitiveType;
            }
        }
        return Optional.empty();
    }

    @Override
    protected Optional<MetaElement> allocateEnumType(Type type) {
        return Optional.empty();
    }

    public void registerPrimitiveType(Class<?> clazz) {
        this.primitiveTypes.add(clazz);
    }

    private static String firstToLower(String name) {
        if (name.equals(JsonNode.class.getSimpleName())) {
            return "json";
        }
        if (name.equals(ObjectNode.class.getSimpleName())) {
            return "json.object";
        }
        if (name.equals(ArrayNode.class.getSimpleName())) {
            return "json.array";
        }
        if (name.equals("UUID")) {
            return "uuid";
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private Class<?> mapPrimitiveType(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private boolean isPrimitiveType(Class<?> clazz) {
        if ((clazz = this.mapPrimitiveType(clazz)) == Object.class) {
            return true;
        }
        if (clazz.getPackage() != null && clazz.getPackage().getName().equals("java.time")) {
            return true;
        }
        if (clazz.isPrimitive() || this.primitiveTypes.contains(clazz)) {
            return true;
        }
        for (Class<?> primitiveType : this.primitiveTypes) {
            if (!primitiveType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void discoverElements() {
    }
}

