/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.model;

import io.crnk.meta.model.MetaAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MetaAttributePath
implements Iterable<MetaAttribute> {
    public static final char PATH_SEPARATOR_CHAR = '.';
    public static final String PATH_SEPARATOR = ".";
    public static final MetaAttributePath EMPTY_PATH = new MetaAttributePath(new MetaAttribute[0]);
    private MetaAttribute[] pathElements;

    public MetaAttributePath(List<? extends MetaAttribute> pathElements) {
        this(pathElements.toArray(new MetaAttribute[pathElements.size()]));
    }

    public MetaAttributePath(MetaAttribute ... pathElements) {
        if (pathElements == null) {
            throw new IllegalArgumentException("pathElements must not be null.");
        }
        this.pathElements = pathElements;
    }

    public MetaAttributePath subPath(int startIndex) {
        MetaAttribute[] range = Arrays.copyOfRange(this.pathElements, startIndex, this.pathElements.length);
        return new MetaAttributePath(range);
    }

    public MetaAttributePath subPath(int startIndex, int endIndex) {
        MetaAttribute[] range = Arrays.copyOfRange(this.pathElements, startIndex, endIndex);
        return new MetaAttributePath(range);
    }

    protected MetaAttribute[] newArray(int length) {
        return new MetaAttribute[length];
    }

    protected MetaAttributePath to(MetaAttribute ... pathElements) {
        return new MetaAttributePath(pathElements);
    }

    public int length() {
        return this.pathElements.length;
    }

    public MetaAttribute getElement(int index) {
        return this.pathElements[index];
    }

    public MetaAttribute getLast() {
        if (this.pathElements != null && this.pathElements.length > 0) {
            return this.pathElements[this.pathElements.length - 1];
        }
        return null;
    }

    public MetaAttributePath concat(MetaAttribute ... pathElements) {
        ArrayList<MetaAttribute> list = new ArrayList<MetaAttribute>();
        list.addAll(Arrays.asList(this.pathElements));
        list.addAll(Arrays.asList(pathElements));
        return this.to(list.toArray(this.newArray(0)));
    }

    public String render(String delimiter) {
        if (this.pathElements.length == 0) {
            return "";
        }
        if (this.pathElements.length == 1) {
            return this.pathElements[0].getName();
        }
        StringBuilder builder = new StringBuilder(this.pathElements[0].getName());
        for (int i = 1; i < this.pathElements.length; ++i) {
            builder.append(delimiter);
            builder.append(this.pathElements[i].getName());
        }
        return builder.toString();
    }

    public String toString() {
        return this.render(PATH_SEPARATOR);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.pathElements);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetaAttributePath) {
            MetaAttributePath other = (MetaAttributePath)obj;
            return Arrays.equals(this.pathElements, other.pathElements);
        }
        return false;
    }

    @Override
    public Iterator<MetaAttribute> iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.pathElements)).iterator();
    }
}

