/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@JsonApiResource(type="meta/element")
public class MetaElement
implements Cloneable {
    @JsonApiId
    private String id;
    private String name;
    @JsonApiRelation(serialize=SerializeType.LAZY, opposite="children", lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private MetaElement parent;
    @JsonApiRelation(opposite="parent", lookUp=LookupIncludeBehavior.AUTOMATICALLY_ALWAYS)
    private List<MetaElement> children = new ArrayList<MetaElement>();

    public MetaElement getParent() {
        return this.parent;
    }

    public void setParent(MetaElement parent) {
        this.parent = parent;
    }

    public List<MetaElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void setChildren(List<MetaElement> children) {
        this.children = children;
    }

    public void addChild(MetaElement child) {
        this.children.add(child);
    }

    public MetaType asType() {
        if (!(this instanceof MetaType)) {
            throw new IllegalStateException(this.getName() + " not a MetaEntity");
        }
        return (MetaType)this;
    }

    public MetaDataObject asDataObject() {
        if (!(this instanceof MetaDataObject)) {
            throw new IllegalStateException(this.getName() + " not a MetaDataObject");
        }
        return (MetaDataObject)this;
    }

    public void setParent(MetaElement parent, boolean attach) {
        this.parent = parent;
        if (parent != null && attach) {
            parent.addChild(this);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
    }

    public final String getId() {
        if (this.id == null) {
            throw new UnsupportedOperationException("id not available for " + this.toString());
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public boolean hasId() {
        return this.id != null;
    }

    public MetaElement duplicate() {
        return (MetaElement)ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<MetaElement>(){

            @Override
            public MetaElement call() throws Exception {
                return (MetaElement)MetaElement.this.clone();
            }
        });
    }
}

