/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.provider;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.utils.Optional;
import io.crnk.meta.model.MetaArrayType;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaEnumType;
import io.crnk.meta.model.MetaListType;
import io.crnk.meta.model.MetaLiteral;
import io.crnk.meta.model.MetaMapType;
import io.crnk.meta.model.MetaPrimitiveType;
import io.crnk.meta.model.MetaSetType;
import io.crnk.meta.model.MetaType;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaPartitionContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MetaPartitionBase
implements MetaPartition {
    protected MetaPartitionContext context;
    protected Map<Type, MetaElement> typeMapping = new HashMap<Type, MetaElement>();
    protected Set<Type> nonUniqueTypes = new HashSet<Type>();
    protected MetaPartition parent;

    @Override
    public void init(MetaPartitionContext context) {
        this.context = context;
    }

    @Override
    public MetaElement getMeta(Type type) {
        MetaElement metaElement = this.typeMapping.get(type);
        if (metaElement == null && this.parent != null) {
            metaElement = this.parent.getMeta(type);
        }
        PreconditionUtil.assertNotNull((String)"should not be null", (Object)metaElement);
        return metaElement;
    }

    @Override
    public boolean hasMeta(Type type) {
        return this.typeMapping.containsKey(type) || this.parent != null && this.parent.hasMeta(type);
    }

    protected Optional<MetaElement> addElement(Type type, MetaElement element) {
        this.context.addElement(element);
        if (type != null && !this.nonUniqueTypes.contains(type)) {
            if (this.typeMapping.containsKey(type)) {
                this.nonUniqueTypes.add(type);
                this.typeMapping.remove(type);
            } else {
                this.typeMapping.put(type, element);
            }
        }
        return Optional.of((Object)element);
    }

    @Override
    public final Optional<MetaElement> allocateMetaElement(Type type) {
        Optional<MetaElement> element;
        if (this.parent != null && (element = this.parent.allocateMetaElement(type)).isPresent()) {
            return element;
        }
        if (this.typeMapping.containsKey(type)) {
            return Optional.of((Object)this.typeMapping.get(type));
        }
        if (type instanceof ParameterizedType && (element = this.allocateMap((ParameterizedType)type)).isPresent()) {
            return element;
        }
        element = this.allocateCollectionType(type);
        if (element.isPresent()) {
            return element;
        }
        element = this.allocateEnumType(type);
        if (element.isPresent()) {
            return element;
        }
        Optional<MetaElement> optElement = this.doAllocateMetaElement(type);
        PreconditionUtil.assertNotNull((String)"must be not null", optElement);
        if (optElement.isPresent() && !((MetaElement)optElement.get()).hasId() && optElement.get() instanceof MetaType) {
            PreconditionUtil.assertTrue((String)"must have an id", (boolean)((MetaElement)optElement.get()).hasId());
        }
        return optElement;
    }

    protected abstract Optional<MetaElement> doAllocateMetaElement(Type var1);

    protected Optional<MetaElement> allocateEnumType(Type type) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            MetaEnumType enumType = new MetaEnumType();
            enumType.setElementType(enumType);
            enumType.setImplementationType(type);
            enumType.setName(clazz.getSimpleName());
            for (Object literalObj : clazz.getEnumConstants()) {
                MetaLiteral literal = new MetaLiteral();
                literal.setName(literalObj.toString());
                literal.setParent(enumType, true);
            }
            return this.addElement(type, enumType);
        }
        return Optional.empty();
    }

    private Optional<MetaElement> allocateCollectionType(Type type) {
        Class<?> elementClass;
        Optional<MetaElement> elementType;
        if (type instanceof Class && ((Class)type).isArray() && (elementType = this.allocateMetaElement(elementClass = ((Class)type).getComponentType())).isPresent()) {
            MetaArrayType arrayType = new MetaArrayType();
            arrayType.setName(((MetaElement)elementType.get()).getName() + "$array");
            arrayType.setId(((MetaElement)elementType.get()).getId() + "$array");
            arrayType.setImplementationType(type);
            arrayType.setElementType((MetaType)elementType.get());
            return this.addElement(type, arrayType);
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length == 1) {
            ParameterizedType paramType = (ParameterizedType)type;
            elementType = this.allocateMetaElement(paramType.getActualTypeArguments()[0]);
            if (!elementType.isPresent()) {
                return Optional.empty();
            }
            boolean isSet = Set.class.isAssignableFrom((Class)paramType.getRawType());
            boolean isList = List.class.isAssignableFrom((Class)paramType.getRawType());
            if (isSet) {
                MetaSetType metaSet = new MetaSetType();
                metaSet.setId(((MetaType)elementType.get()).getId() + "$set");
                metaSet.setName(((MetaType)elementType.get()).getName() + "$set");
                metaSet.setImplementationType(paramType);
                metaSet.setElementType((MetaType)elementType.get());
                return this.addElement(type, metaSet);
            }
            if (isList) {
                PreconditionUtil.assertTrue((String)"expected a list type", (boolean)isList);
                MetaListType metaList = new MetaListType();
                metaList.setId(((MetaType)elementType.get()).getId() + "list");
                metaList.setName(((MetaType)elementType.get()).getName() + "$list");
                metaList.setImplementationType(paramType);
                metaList.setElementType((MetaType)elementType.get());
                return this.addElement(type, metaList);
            }
        }
        return Optional.empty();
    }

    private Optional<MetaElement> allocateMap(ParameterizedType paramType) {
        if (paramType.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)paramType.getRawType())) {
            PreconditionUtil.assertEquals((String)"expected 2 type arguments", (Object)2, (Object)paramType.getActualTypeArguments().length);
            Optional<MetaElement> optKeyType = this.allocateMetaElement(paramType.getActualTypeArguments()[0]);
            Optional<MetaElement> optValueType = this.allocateMetaElement(paramType.getActualTypeArguments()[1]);
            if (optKeyType.isPresent() && optValueType.isPresent()) {
                MetaType keyType = (MetaType)optKeyType.get();
                MetaType valueType = (MetaType)optValueType.get();
                MetaMapType mapMeta = new MetaMapType();
                boolean primitiveKey = keyType instanceof MetaPrimitiveType;
                boolean primitiveValue = valueType instanceof MetaPrimitiveType;
                if (primitiveKey || !primitiveValue) {
                    mapMeta.setName(valueType.getName() + "$mappedBy$" + keyType.getName());
                    mapMeta.setId(valueType.getId() + "$mappedBy$" + keyType.getName());
                } else {
                    mapMeta.setName(keyType.getName() + "$map$" + valueType.getName());
                    mapMeta.setId(keyType.getId() + "$map$" + valueType.getName());
                }
                mapMeta.setImplementationType(paramType);
                mapMeta.setKeyType(keyType);
                mapMeta.setElementType(valueType);
                return this.addElement(paramType, mapMeta);
            }
        }
        return Optional.empty();
    }
}

