/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal.typed;

import io.crnk.core.module.Module;
import io.crnk.core.utils.Optional;
import io.crnk.meta.internal.typed.TypedMetaElementFactory;
import io.crnk.meta.internal.typed.TypedMetaElementFactoryContext;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.provider.MetaPartitionBase;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class TypedMetaPartitionBase
extends MetaPartitionBase {
    private List<TypedMetaElementFactory> factories = new CopyOnWriteArrayList<TypedMetaElementFactory>();

    protected void addFactory(TypedMetaElementFactory factory) {
        if (!this.factories.contains(factory)) {
            factory.init(new TypedMetaElementFactoryContext(){

                @Override
                public MetaElement allocate(Type type) {
                    return (MetaElement)TypedMetaPartitionBase.this.allocateMetaElement(type).get();
                }

                @Override
                public Module.ModuleContext getModuleContext() {
                    return TypedMetaPartitionBase.this.context.getModuleContext();
                }
            });
            this.factories.add(factory);
        }
    }

    @Override
    protected Optional<MetaElement> doAllocateMetaElement(Type type) {
        for (TypedMetaElementFactory factory : this.factories) {
            if (!factory.accept(type)) continue;
            MetaElement element = factory.create(type);
            this.addElement(type, element);
            return Optional.of((Object)element);
        }
        return Optional.empty();
    }
}

