/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal.resource;

import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.Module;
import io.crnk.core.utils.Optional;
import io.crnk.meta.internal.resource.ResourceMetaParitition;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.model.MetaCollectionType;
import io.crnk.meta.model.MetaDataObject;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.model.MetaListType;
import io.crnk.meta.model.MetaPrimaryKey;
import io.crnk.meta.model.MetaSetType;
import io.crnk.meta.model.resource.MetaJsonObject;
import io.crnk.meta.model.resource.MetaResource;
import io.crnk.meta.model.resource.MetaResourceBase;
import io.crnk.meta.model.resource.MetaResourceField;
import io.crnk.meta.provider.MetaFilter;
import io.crnk.meta.provider.MetaProviderContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;

public class ResourceMetaFilter
implements MetaFilter {
    private final MetaProviderContext context;
    private final ResourceMetaParitition partition;

    public ResourceMetaFilter(ResourceMetaParitition partition, MetaProviderContext context) {
        PreconditionUtil.assertNotNull((String)"must not be null", (Object)context);
        this.context = context;
        this.partition = partition;
    }

    @Override
    public MetaElement adjustForRequest(MetaElement element) {
        if (element instanceof MetaResource) {
            MetaResource metaResource = (MetaResource)element;
            return this.adjustResourceForRequest(metaResource);
        }
        if (element instanceof MetaResourceField && element.getParent() instanceof MetaResource) {
            MetaResourceField field = (MetaResourceField)element;
            return this.adjustFieldForRequest(field);
        }
        return element;
    }

    private MetaElement adjustFieldForRequest(MetaResourceField field) {
        boolean updatable;
        MetaResource metaResource = (MetaResource)field.getParent();
        Module.ModuleContext moduleContext = this.context.getModuleContext();
        RegistryEntry entry = moduleContext.getResourceRegistry().getEntry(metaResource.getResourceType());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        ResourceField fieldInformation = resourceInformation.findFieldByUnderlyingName(field.getName());
        ResourceFilterDirectory filterBehaviorProvider = moduleContext.getResourceFilterDirectory();
        boolean readable = metaResource.isReadable() && filterBehaviorProvider.get(fieldInformation, HttpMethod.GET) == FilterBehavior.NONE;
        boolean insertable = metaResource.isInsertable() && filterBehaviorProvider.get(fieldInformation, HttpMethod.POST) == FilterBehavior.NONE;
        boolean bl = updatable = metaResource.isUpdatable() && filterBehaviorProvider.get(fieldInformation, HttpMethod.PATCH) == FilterBehavior.NONE;
        if (!(readable || insertable || updatable)) {
            return null;
        }
        if (field.isUpdatable() != updatable || field.isInsertable() != insertable) {
            MetaResourceField clone = (MetaResourceField)field.duplicate();
            clone.setInsertable(insertable);
            clone.setUpdatable(updatable);
            return clone;
        }
        return field;
    }

    private MetaElement adjustResourceForRequest(MetaResource metaResource) {
        boolean deletable;
        Module.ModuleContext moduleContext = this.context.getModuleContext();
        RegistryEntry entry = moduleContext.getResourceRegistry().getEntry(metaResource.getResourceType());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        ResourceFilterDirectory filterBehaviorProvider = moduleContext.getResourceFilterDirectory();
        boolean readable = metaResource.isReadable() && filterBehaviorProvider.get(resourceInformation, HttpMethod.GET) == FilterBehavior.NONE;
        boolean insertable = metaResource.isInsertable() && filterBehaviorProvider.get(resourceInformation, HttpMethod.POST) == FilterBehavior.NONE;
        boolean updatable = metaResource.isUpdatable() && filterBehaviorProvider.get(resourceInformation, HttpMethod.PATCH) == FilterBehavior.NONE;
        boolean bl = deletable = metaResource.isDeletable() && filterBehaviorProvider.get(resourceInformation, HttpMethod.DELETE) == FilterBehavior.NONE;
        if (!(readable || insertable || updatable || deletable)) {
            return null;
        }
        if (metaResource.isReadable() != readable || metaResource.isUpdatable() != updatable || metaResource.isInsertable() != insertable || metaResource.isDeletable() != deletable) {
            MetaResource clone = (MetaResource)metaResource.duplicate();
            clone.setReadable(readable);
            clone.setInsertable(insertable);
            clone.setUpdatable(updatable);
            clone.setDeletable(deletable);
            return clone;
        }
        return metaResource;
    }

    @Override
    public void onInitializing(MetaElement element) {
    }

    @Override
    public void onInitialized(MetaElement element) {
        MetaDataObject parent;
        MetaAttribute attr;
        String oppositeType;
        if (element instanceof MetaResourceBase) {
            MetaResourceBase metaResource = (MetaResourceBase)element;
            ResourceInformation information = this.getResourceInformation(metaResource, true);
            PreconditionUtil.assertNotNull((String)information.getResourceType(), (Object)metaResource);
            for (ResourceField field : information.getRelationshipFields()) {
                if (field.getOppositeName() == null) continue;
                oppositeType = field.getOppositeResourceType();
                MetaResource oppositeMeta = (MetaResource)this.context.getMetaElement(this.partition.getId(oppositeType)).get();
                MetaAttribute attr2 = metaResource.getAttribute(field.getUnderlyingName());
                MetaAttribute oppositeAttr = oppositeMeta.getAttribute(field.getOppositeName());
                PreconditionUtil.assertNotNull((String)(attr2.getId() + " opposite not found"), (Object)oppositeAttr);
                attr2.setOppositeAttribute(oppositeAttr);
            }
            ResourceField idField = information.getIdField();
            if (idField != null) {
                MetaAttribute idAttr = metaResource.getAttribute(idField.getUnderlyingName());
                idAttr.setPrimaryKeyAttribute(true);
                if (metaResource.getSuperType() == null || metaResource.getSuperType().getPrimaryKey() == null) {
                    MetaPrimaryKey primaryKey = new MetaPrimaryKey();
                    primaryKey.setName(metaResource.getName() + "$primaryKey");
                    primaryKey.setName(metaResource.getId() + "$primaryKey");
                    primaryKey.setElements(Arrays.asList(idAttr));
                    primaryKey.setUnique(true);
                    primaryKey.setParent(metaResource, true);
                    metaResource.setPrimaryKey(primaryKey);
                    this.partition.addElement(null, primaryKey);
                }
            }
        }
        if (element instanceof MetaAttribute && element.getParent() instanceof MetaResourceBase) {
            ResourceField field;
            attr = (MetaAttribute)element;
            parent = (MetaResourceBase)attr.getParent();
            ResourceInformation information = this.getResourceInformation((MetaResourceBase)parent, true);
            field = information.findFieldByUnderlyingName(attr.getName());
            PreconditionUtil.assertNotNull((String)attr.getName(), (Object)field);
            if (field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP) {
                oppositeType = field.getOppositeResourceType();
                String oppositeId = this.partition.getId(oppositeType);
                Optional<MetaElement> optOppositeMeta = this.context.getMetaElement(oppositeId);
                if (!optOppositeMeta.isPresent()) {
                    throw new IllegalStateException("opposite meta element '" + oppositeId + "' for element '" + element.getId() + "' not found");
                }
                MetaResource oppositeMeta = (MetaResource)optOppositeMeta.get();
                if (field.isCollection()) {
                    MetaCollectionType metaCollection;
                    boolean isSet = Set.class.isAssignableFrom(field.getType());
                    String suffix = isSet ? "$set" : "$list";
                    Optional<MetaElement> optMetaCollection = this.context.getMetaElement(oppositeId + suffix);
                    if (optMetaCollection.isPresent()) {
                        metaCollection = (MetaCollectionType)optMetaCollection.get();
                    } else {
                        metaCollection = isSet ? new MetaSetType() : new MetaListType();
                        metaCollection.setId(oppositeMeta.getId() + suffix);
                        metaCollection.setName(oppositeMeta.getName() + suffix);
                        metaCollection.setImplementationType(field.getGenericType());
                        metaCollection.setElementType(oppositeMeta);
                        this.partition.addElement(null, metaCollection);
                    }
                    attr.setType(metaCollection);
                } else {
                    attr.setType(oppositeMeta);
                }
            } else {
                Type implementationType = field.getGenericType();
                MetaElement metaType = (MetaElement)this.partition.allocateMetaElement(implementationType).get();
                attr.setType(metaType.asType());
            }
        } else if (element instanceof MetaAttribute && element.getParent() instanceof MetaJsonObject) {
            attr = (MetaAttribute)element;
            parent = attr.getParent();
            Type implementationType = PropertyUtils.getPropertyType(parent.getImplementationClass(), (String)attr.getName());
            MetaElement metaType = (MetaElement)this.partition.allocateMetaElement(implementationType).get();
            attr.setType(metaType.asType());
        }
    }

    private ResourceInformation getResourceInformation(MetaResourceBase meta, boolean allowNull) {
        RegistryEntry entry;
        ResourceRegistry resourceRegistry = this.context.getModuleContext().getResourceRegistry();
        if (meta instanceof MetaResource && (entry = resourceRegistry.getEntry(((MetaResource)meta).getResourceType())) != null) {
            return entry.getResourceInformation();
        }
        Class<?> resourceClass = meta.getImplementationClass();
        ResourceInformationProvider infoBuilder = this.context.getModuleContext().getResourceInformationBuilder();
        if (infoBuilder.accept(resourceClass)) {
            return infoBuilder.build(resourceClass);
        }
        if (allowNull) {
            return null;
        }
        throw new IllegalStateException("failed to get information for " + resourceClass.getName());
    }
}

