/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta.internal;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.utils.Supplier;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.internal.MetaUtils;
import io.crnk.meta.model.MetaElement;
import java.util.ArrayList;
import java.util.Collection;

public class MetaRelationshipRepositoryImpl
implements RelationshipRepositoryV2<MetaElement, String, MetaElement, String>,
HttpRequestContextAware {
    private Supplier<MetaLookup> lookupSupplier;
    private Class<? extends MetaElement> sourceResourceClass;
    private Class<? extends MetaElement> targetResourceClass;
    private HttpRequestContextProvider requestContextProvider;

    public MetaRelationshipRepositoryImpl(Supplier<MetaLookup> lookupSupplier, Class<? extends MetaElement> sourceClass, Class<? extends MetaElement> targetClass) {
        this.lookupSupplier = lookupSupplier;
        this.sourceResourceClass = sourceClass;
        this.targetResourceClass = targetClass;
    }

    public MetaElement findOneTarget(String sourceId, String fieldName, QuerySpec querySpec) {
        MetaElement source = this.getSource(sourceId);
        Object value = this.adjustForRequest(PropertyUtils.getProperty((Object)source, (String)fieldName));
        return (MetaElement)value;
    }

    public ResourceList<MetaElement> findManyTargets(String sourceId, String fieldName, QuerySpec querySpec) {
        MetaElement source = this.getSource(sourceId);
        Object value = this.adjustForRequest(PropertyUtils.getProperty((Object)source, (String)fieldName));
        return querySpec.apply((Iterable)((Collection)value));
    }

    private MetaElement getSource(String sourceId) {
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        MetaElement source = lookup.getMetaById().get(sourceId);
        if (source == null) {
            throw new ResourceNotFoundException(sourceId);
        }
        return source;
    }

    public Class<MetaElement> getSourceResourceClass() {
        return this.sourceResourceClass;
    }

    public Class<MetaElement> getTargetResourceClass() {
        return this.targetResourceClass;
    }

    public void setRelation(MetaElement source, String targetId, String fieldName) {
        throw this.newReadOnlyException();
    }

    public void setRelations(MetaElement source, Iterable<String> targetIds, String fieldName) {
        throw this.newReadOnlyException();
    }

    public void addRelations(MetaElement source, Iterable<String> targetIds, String fieldName) {
        throw this.newReadOnlyException();
    }

    public void removeRelations(MetaElement source, Iterable<String> targetIds, String fieldName) {
        throw this.newReadOnlyException();
    }

    private UnsupportedOperationException newReadOnlyException() {
        return new UnsupportedOperationException("read-only");
    }

    private Object adjustForRequest(Object object) {
        HttpRequestContext requestContext = this.requestContextProvider.getRequestContext();
        QueryContext queryContext = requestContext.getQueryContext();
        if (object == null) {
            return null;
        }
        if (object instanceof MetaElement) {
            return MetaUtils.adjustForRequest((MetaLookup)this.lookupSupplier.get(), (MetaElement)object, queryContext);
        }
        PreconditionUtil.assertTrue((String)"expected collection", (boolean)(object instanceof Collection));
        ArrayList<MetaElement> results = new ArrayList<MetaElement>();
        MetaLookup lookup = (MetaLookup)this.lookupSupplier.get();
        for (MetaElement element : (Collection)object) {
            MetaElement adjustedElement = MetaUtils.adjustForRequest(lookup, element, queryContext);
            if (adjustedElement == null) continue;
            results.add(adjustedElement);
        }
        return results;
    }

    public void setHttpRequestContextProvider(HttpRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
    }
}

