/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.meta;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.module.Module;
import io.crnk.core.utils.Optional;
import io.crnk.meta.internal.BaseMetaPartition;
import io.crnk.meta.model.MetaElement;
import io.crnk.meta.provider.MetaFilter;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaPartitionContext;
import io.crnk.meta.provider.MetaProvider;
import io.crnk.meta.provider.MetaProviderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaLookup.class);
    private LinkedList<MetaElement> initializationQueue = new LinkedList();
    private boolean discovering = false;
    private BaseMetaPartition basePartition;
    private boolean discovered;
    private Module.ModuleContext moduleContext;
    private List<MetaPartition> partitions = new ArrayList<MetaPartition>();
    private ConcurrentHashMap<String, MetaElement> idElementMap = new ConcurrentHashMap();
    private List<MetaFilter> filters = new CopyOnWriteArrayList<MetaFilter>();
    private List<MetaProvider> providers = new CopyOnWriteArrayList<MetaProvider>();
    private Set<Class<? extends MetaElement>> metaTypes = new HashSet<Class<? extends MetaElement>>();

    public MetaLookup() {
        this.basePartition = new BaseMetaPartition();
        this.addPartition(this.basePartition);
    }

    public void addProvider(MetaProvider provider) {
        this.providers.add(provider);
        provider.init(new MetaProviderContext(){

            @Override
            public Module.ModuleContext getModuleContext() {
                return MetaLookup.this.moduleContext;
            }

            @Override
            public Optional<MetaElement> getMetaElement(String id) {
                return Optional.ofNullable(MetaLookup.this.idElementMap.get(id));
            }

            @Override
            public void checkInitialized() {
                MetaLookup.this.checkInitialized();
            }

            @Override
            public <T> T runDiscovery(Callable<T> callable) {
                return (T)MetaLookup.this.discover(callable);
            }
        });
        for (MetaFilter filter : provider.getFilters()) {
            this.addFilter(filter);
        }
        for (MetaPartition partition : provider.getPartitions()) {
            this.addPartition(partition);
        }
        this.metaTypes.addAll(provider.getMetaTypes());
    }

    private void addPartition(MetaPartition partition) {
        this.partitions.add(partition);
        partition.init(new MetaPartitionContext(){

            @Override
            public void addElement(MetaElement element) {
                MetaLookup.this.add(element);
            }

            @Override
            public Module.ModuleContext getModuleContext() {
                return MetaLookup.this.moduleContext;
            }

            @Override
            public Optional<MetaElement> getMetaElement(String id) {
                return Optional.ofNullable(MetaLookup.this.idElementMap.get(id));
            }

            @Override
            public MetaPartition getBasePartition() {
                return MetaLookup.this.basePartition;
            }
        });
    }

    private void addFilter(MetaFilter filter) {
        this.filters.add(filter);
    }

    public void setModuleContext(Module.ModuleContext moduleContext) {
        this.moduleContext = moduleContext;
    }

    public void registerPrimitiveType(Class<?> clazz) {
        this.basePartition.registerPrimitiveType(clazz);
    }

    public Map<String, MetaElement> getMetaById() {
        this.checkInitialized();
        return Collections.unmodifiableMap(this.idElementMap);
    }

    public void add(MetaElement element) {
        PreconditionUtil.assertTrue((String)"no discovering", (boolean)this.discovering);
        PreconditionUtil.assertNotNull((String)"no name provided", (Object)element.getName());
        if (!element.hasId() && element.getParent() != null) {
            element.setId(element.getParent().getId() + "." + element.getName());
        }
        PreconditionUtil.assertNull((String)"already exists", (Object)this.idElementMap.get(element.getId()));
        LOGGER.debug("add {} of type {}", (Object)element.getId(), (Object)element.getClass().getSimpleName());
        this.initializationQueue.add(element);
        MetaElement currentElement = this.idElementMap.get(element.getId());
        PreconditionUtil.assertNull((String)element.getId(), (Object)currentElement);
        this.idElementMap.put(element.getId(), element);
        for (MetaElement child : element.getChildren()) {
            this.add(child);
        }
    }

    private void checkInitialized() {
        if (!this.discovered && !this.discovering) {
            this.initialize();
        }
    }

    public void initialize() {
        this.discover(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (!MetaLookup.this.discovered) {
                    for (MetaPartition provider : MetaLookup.this.partitions) {
                        provider.discoverElements();
                    }
                    MetaLookup.this.discovered = true;
                }
                return null;
            }
        });
    }

    private <T> T discover(Callable<T> callable) {
        LOGGER.debug("discovery started");
        this.discovering = true;
        try {
            T result = callable.call();
            while (!this.initializationQueue.isEmpty()) {
                MetaElement element = this.initializationQueue.pollFirst();
                if (element.getParent() != null) continue;
                this.initialize(element);
            }
            LOGGER.debug("discovery completed");
            T t = result;
            return t;
        }
        catch (Exception e) {
            LOGGER.debug("discovery failed", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            this.discovering = false;
        }
    }

    private void initialize(MetaElement element) {
        LOGGER.debug("discovering {}", (Object)element.getId());
        for (MetaFilter filter : this.filters) {
            filter.onInitializing(element);
        }
        for (MetaElement child : element.getChildren()) {
            this.initialize(child);
        }
        for (MetaFilter filter : this.filters) {
            filter.onInitialized(element);
        }
        LOGGER.debug("added {}", (Object)element.getId());
    }

    public <T extends MetaElement> List<T> findElements(Class<T> metaType) {
        ArrayList<MetaElement> list = new ArrayList<MetaElement>();
        for (MetaElement element : this.idElementMap.values()) {
            if (!metaType.isInstance(element)) continue;
            list.add(element);
        }
        return list;
    }

    public void putElement(MetaElement element) {
        this.idElementMap.put(element.getId(), element);
    }

    protected Module.ModuleContext getContext() {
        return this.moduleContext;
    }

    public List<MetaFilter> getFilters() {
        return this.filters;
    }

    public <T extends MetaPartition> T getPartition(Class clazz) {
        for (MetaPartition partition : this.partitions) {
            if (!clazz.isInstance(partition)) continue;
            return (T)partition;
        }
        throw new IllegalStateException();
    }
}

